<?php
/**
 * Downloads
 *
 * Shows downloads on the account page.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/downloads.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if (1==2) {



	$downloads     = WC()->customer->get_downloadable_products();
	$has_downloads = (bool) $downloads;

	do_action( 'woocommerce_before_account_downloads', $has_downloads ); ?>

	<?php if ( $has_downloads ) : ?>

		<?php do_action( 'woocommerce_before_available_downloads' ); ?>

		<?php do_action( 'woocommerce_available_downloads', $downloads ); ?>

		<?php do_action( 'woocommerce_after_available_downloads' ); ?>

	<?php else : ?>
		<div class="woocommerce-Message woocommerce-Message--info woocommerce-info">
			<a class="woocommerce-Button button" href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>">
				<?php esc_html_e( 'مشاهده‌ی دوره‌های آموزشی', 'hamyarlearn' ); ?>
			</a>
			<?php esc_html_e( 'No downloads available yet.', 'woocommerce' ); ?>
		</div>
	<?php endif; ?>

	<?php do_action( 'woocommerce_after_account_downloads', $has_downloads );



} else {




?>
<h2 style="color:#333;">
	<?php echo __('دانلودها' , 'hamyarlearn') ?>
</h2>
<?php
	$downloads = WC()->customer->get_downloadable_products();
	$has_downloads = (bool)$downloads;

	if( $has_downloads ) {
	    $shweb_downloads = array();
	    foreach ($downloads as $shweb_download) {
	        $shweb_downloads[$shweb_download['product_id']][$shweb_download['order_id']][] = $shweb_download;
	    }
	}

	do_action('woocommerce_before_account_downloads', $has_downloads);

	if ($has_downloads) :
		do_action('woocommerce_before_available_downloads'); ?>
	    <ul class="shweb-dl-items">
	        <?php foreach ($shweb_downloads as $product_id => $orders_download): ?>
	           <li class="dl-item">
							 <div class="row">
		 						<div class="col-12">
									<a class="top-dl-bar" href="<?php echo get_the_permalink($product_id); ?>">
			 							<div class="product-img">
											<?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), 'single-post-thumbnail' );?>
			 								<?php //<img src="</?php echo $image[0]; ?/>" data-id="</?php echo $product_id; ?/>"> ?>
											<?php echo get_the_post_thumbnail( $product_id, false ); ?>
			 							</div>
			 							<div class="product-title">
			 								<?php echo get_the_title($product_id); ?>
			 							</div>
									</a>
		 						</div>
		 						<div class="col-12">
									<div class="shweb-dl-items row">
										<?php foreach($orders_download  as $order_id => $download_items ): ?>
												<div class="shweb-files-list">
													<?php if( !empty($download_items) ): ?>
														<table class="table">
															<thead>
																<tr>
																	<th><?php _e('File', 'woocommerce'); ?></th>
																	<th><?php _e('Downloads remaining', 'woocommerce'); ?></th>
																	<th><?php _e('Expires', 'woocommerce'); ?></th>
																</tr>
															</thead>
															<tbody>
																<?php foreach($download_items  as $key => $shweb_download ): ?>
																	<tr>
																		<td id="dl-link"><a class="" href="<?php echo esc_url( $shweb_download['download_url'] ); ?>"><?php echo $shweb_download['file']['name'] ?></a></td>
																		<td><?php echo is_numeric( $shweb_download['downloads_remaining'] ) ? esc_html( $shweb_download['downloads_remaining'] ) : __( '&infin;', 'woocommerce' ); ?></td>
																		<td>
																		<?php if ( ! empty( $shweb_download['access_expires'] ) ) : ?>
																			<time datetime="<?php echo date( 'Y-m-d', strtotime( $shweb_download['access_expires'] ) ); ?>" title="<?php echo esc_attr( strtotime( $shweb_download['access_expires'] ) ); ?>"><?php echo date_i18n( get_option( 'date_format' ), strtotime( $shweb_download['access_expires'] ) ); ?></time>
																		<?php else : ?>
																			<?php _e( 'Never', 'woocommerce' ); ?>
																		<?php endif; ?>
																	</td>
																</tr>
															<?php endforeach; ?>
														</tbody>
													</table>
													<?php endif; ?>
												</div>
									<?php endforeach; ?>
								</div>
							</div>
						</div>
					</li>
				<?php endforeach; ?>
			</ul>



	    <?php do_action('woocommerce_after_available_downloads'); ?>

	<?php else : ?>
		<div class="woocommerce-Message woocommerce-Message--info woocommerce-info">
			<a class="woocommerce-Button button" href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>">
				<?php esc_html_e( 'مشاهده‌ی دوره‌های آموزشی', 'hamyarlearn' ); ?>
			</a>
			<?php esc_html_e( 'No downloads available yet.', 'woocommerce' ); ?>
		</div>
	<?php endif; ?>

	<?php do_action('woocommerce_after_account_downloads', $has_downloads);




}
