<?php
/**
 * Initialize the custom theme options.
 */
add_action( 'init', 'custom_theme_options' );

/**
 * Build the custom settings & update OptionTree.
 */
function custom_theme_options() {

	// OptionTree is not loaded yet, or this is not an admin request.
	if ( ! function_exists( 'ot_settings_id' ) || ! is_admin() ) {
		return false;
	}

	// Get a copy of the saved settings array.
	$saved_settings = get_option( ot_settings_id(), array() );
	// Custom settings array that will eventually be passes to the OptionTree Settings API Class.
	$custom_settings = array(
		'contextual_help' => array(
			'content' => array(
				array(
					'id'      => 'how_to_use',
					'title'   => esc_html__( 'نحوه‌ی اعمال تغییرات در قالب', 'hamyarlearn' ),
					'content' => esc_html__( 'برای تنظیم کردن قالب در هر زمان، تنها کافیست به این بخش بیایید و تغییرات تان را اعمال کنید.<br>
مثلا برای تنظیم لوگویتان، باید در بخش تنظیمات اصلی، روی دکمه‌ی + کلیک کنید و تصویر را در سایز خواسته شده، آپلود کنید و قرار دهید.<br>
پس از اعمال کلی تنظیمات، روی دکمه‌ی "ذخیره‌ی تغییرات" کلیک کنید.', 'hamyarlearn' ),
				),

			array(
				'id'      => 'how_to_start',
				'title'   => esc_html__( 'شروع کار با تنظیمات', 'hamyarlearn' ),
				'content' => esc_html__( 'برای شروع استفاده از تنظیمات قالب همیار لرن، در صورتی که از بسته‌ی نصب آسان استفاده نکردید، باید یکبار تمام گزینه‌های ON/OFF در تنظیمات را Off و مجددا On کنید و سپس از آنها استفاده کنید. نکته‌ی مهم: در صورت انتشار بروزرسانی جدید برای قالب، باید مواردی که اضافه شدند را بررسی کنید و یکبار آنها را نیز Off و مجددا On کنید.', 'hamyarlearn' ),
			),
						),
			'sidebar' => esc_html__( '<p style="text-align:center">
راهنمای تنظیمات قالب<br>مجموعه‌ی وردپرس با شایان<br>قالب همیار لرن
</p>', 'hamyarlearn' ),
		),
		'sections'        => array(
			array(
				'id'    => 'general_settings',
				'title' => esc_html__( 'تنظیمات اصلی', 'hamyarlearn' ),
			),
			array(
				'id'    => 'color_settings',
				'title' => esc_html__( 'تنظیمات رنگ‌ها', 'hamyarlearn' ),
			),
			array(
				'id'    => 'shtemplates_settings',
				'title' => esc_html__( 'تنظیمات متمایز ساز همیار لرن!! "جدید!"', 'hamyarlearn' ),
			),
			array(
				'id'    => 'slider_settings',
				'title' => esc_html__( 'تنظیمات اسلایدر', 'hamyarlearn' ),
			),
			array(
				'id'    => 'links_sttings',
				'title' => esc_html__( 'لینک‌ها', 'hamyarlearn' ),
			),
			array(
				'id'    => 'bookarea_settings',
				'title' => esc_html__( 'باکس دانلود کتاب در صفحه‌ی اصلی', 'hamyarlearn' ),
			),
			array(
				'id'    => 'count_home',
				'title' => esc_html__( 'آمار صفحه‌ی اصلی', 'hamyarlearn' ),
			),
			array(
				'id'    => 'course_page_settings',
				'title' => esc_html__( 'تنظیمات صفحه‌ی دوره/محصول', 'hamyarlearn' ),
			),
			array(
				'id'    => 'post_settings',
				'title' => esc_html__( 'تنظیمات صفحه‌ی مقاله', 'hamyarlearn' ),
			),
			array(
				'id'    => 'menu_notice',
				'title' => esc_html__( 'تنظیمات اعلان منوی موبایل', 'hamyarlearn' ),
			),
			array(
				'id'    => 'fast_reg_mobile',
				'title' => esc_html__( 'تنظیمات دکمه‌ی ثبت‌نام سریع موبایل در صفحه دوره', 'hamyarlearn' ),
			),
			array(
				'id'    => 'css_settings',
				'title' => esc_html__( 'css اختصاصی', 'hamyarlearn' ),
			),
			array(
				'id'    => 'advice_box',
				'title' => esc_html__( 'درخواست مشاوره', 'hamyarlearn' ),
			),
			array(
				'id'    => 'advice_form',
				'title' => esc_html__( 'فرم درخواست مشاوره', 'hamyarlearn' ),
			),
			array(
				'id'    => 'footer_settings',
				'title' => esc_html__( 'فوتر', 'hamyarlearn' ),
			),
			array(
				'id'    => 'scoials_settings',
				'title' => esc_html__( 'تنظیمات شبکه‌های اجتماعی', 'hamyarlearn' ),
			),
			array(
				'id'    => 'count_products',
				'title' => esc_html__( 'تعداد محصولات', 'hamyarlearn' ),
			),
			array(
				'id'    => 'footer_wwsh_codes',
				'title' => esc_html__( 'کدهای فوتر', 'hamyarlearn' ),
			),
		),
		'settings'        => array(
			array(
				'id'           => 'sitefont',
				'label'        => esc_html__( 'دوست دارید فونت سایت شما، چه فونتی باشد؟', 'hamyarlearn' ),
				'desc'         => esc_html__( 'در نسخه‌ی جدید قالب همیار لرن، می‌توانید فونت‌های مورد نظر خود را برای سایت تان انتخاب کنید!!', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'select',
				'section'      => 'general_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
				'choices'      => array(
					array(
						'value' => 'shabnam',
						'label' => esc_html__( 'فونت شبنم', 'hamyarlearn' ),
						'src'   => '',
					),
					array(
						'value' => 'tanha',
						'label' => esc_html__( 'فونت تنها', 'hamyarlearn' ),
						'src'   => '',
					),
					array(
						'value' => 'samim',
						'label' => esc_html__( 'فونت صمیم', 'hamyarlearn' ),
						'src'   => '',
					),
					array(
						'value' => 'sahel',
						'label' => esc_html__( 'فونت ساحل', 'hamyarlearn' ),
						'src'   => '',
					),
					array(
						'value' => 'nahid',
						'label' => esc_html__( 'فونت ناهید', 'hamyarlearn' ),
						'src'   => '',
					),
					array(
						'value' => 'gandom',
						'label' => esc_html__( 'فونت گندم', 'hamyarlearn' ),
						'src'   => '',
					),
				),
			),
			array(
				'id'           => 'darkmode',
				'label'        => esc_html__( 'دارک مود', 'hamyarlearn' ),
				'desc'         => esc_html__( 'سایت شما بصورت دارک مود و حالت تاریک در می‌آید.<br>
				با on و off می‌توانید این حالت را فعال یا غیرفعال کنید.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'general_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'sitelogo',
				'label'        => esc_html__( 'لوگوی سایت', 'hamyarlearn' ),
				'desc'         => esc_html__( 'لوگوی سایت تان را قرار دهید. سایز لوگو:<br>
عرض: 61 پیکسل<br>
طول: 61 پیکسل', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'general_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'sitefooterlogo',
				'label'        => esc_html__( 'لوگوی فوتر', 'hamyarlearn' ),
				'desc'         => esc_html__( 'یک لوگوی سفید رنگ قرار دهید. سایز لوگو:<br>
عرض: 61 پیکسل<br>
طول: 61 پیکسل', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'general_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'site404pageimg',
				'label'        => esc_html__( 'تصویر 404', 'hamyarlearn' ),
				'desc'         => esc_html__( 'تصویر برای صفحه‌ی 404 سایت', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'general_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'hm_designed_scrollbar',
				'label'        => esc_html__( 'اسکرول بار همیار لرن یا حالت عادی مرورگر؟', 'hamyarlearn' ),
				'desc'         => esc_html__( '(منظور از اسکرول بار، نوار کناری
			در مرورگر هست که با کمک آن صفحه را جابجا می‌کنید)<br>
			می‌خواهید اسکرول بار صفحات سایت تان حالت عادی مرورگر که در اکثر سایت‌ها وجود دارد باشد
			یا اختصاصی همیار لرن (که به رنگ قالب شما هست)<br>
			توجه داشته باشید که این قابلیت در مرورگر فایرفاکس فعال نیست و صرفا برای کروم و یکسری مرورگر دیگر هست.<br>
			برای فعال کردن همیار لرن، روی on و برای غیرفعال کردن (حالت عادی مرورگر) روی off قرار دهید.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'general_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'sticky_header_on_off',
				'label'        => esc_html__( 'فعالسازی هدر چسبان (sticky)؟', 'hamyarlearn' ),
				'desc'         => esc_html__( 'در هدر چسبان، هدر بصورت ثابت در بالای سایت می‌ماند و با اسکرول هم همان‌جا قرار دارد.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'general_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			// array(
			// 	'id'           => 'elementor_header_on',
			// 	'label'        => esc_html__( 'نمایش هدر اصلی یا شورتکد المنتور؟', 'hamyarlearn' ),
			// 	'desc'         => esc_html__( 'با on بودن، هدر اصلی نمایش داده می‌شود و با off بودن، هدر المنتوری (طراحی شده با شورتکد)<br><br>
			// 	دو نکته‌ی مهم:<br>
			// 	نکته‌ی اول: اگر اولین بار است از این تنظیم استفاده می‌کنید، یکبار off کنید و مجددا on کنید و سپس استفاده کنید.<br>
			// 	نکته‌ی دوم: حتما باید المنتور پرو را خریداری و نصب کرده باشید تا بتوانید از هدر المنتوری استفاده کنید. چون المنتور رایگان، شورتکد ندارد.', 'hamyarlearn' ),
			// 	'std'          => '',
			// 	'type'         => 'on-off',
			// 	'section'      => 'general_settings',
			// 	'rows'         => '',
			// 	'post_type'    => '',
			// 	'taxonomy'     => '',
			// 	'min_max_step' => '',
			// 	'class'        => '',
			// 	'condition'    => '',
			// 	'operator'     => 'and',
			// ),
			// array(
			// 	'id'           => 'elementor_shortcode',
			// 	'label'        => esc_html__( 'شورتکد المنتور هدر', 'hamyarlearn' ),
			// 	'desc'         => esc_html__( 'اگر روی OFF قرار دادید، در این بخش باید شورتکد المنتور خود را وارد کنید.<br><br>
			// 	<span style="color:red;">حتما باید المنتور پرو را خریداری و روی این سایت‌تان، نصب کرده باشید.</span><br>
			// 	با کمک <a href="https://elementorfa.ir/%d9%86%d9%85%d8%a7%db%8c%d8%b4-%d9%82%d8%a7%d9%84%d8%a8-%d9%87%d8%a7%db%8c-%d8%a7%d9%84%d9%85%d9%86%d8%aa%d9%88%d8%b1-%d8%a8%d8%a7-%d8%b4%d9%88%d8%b1%d8%aa-%da%a9%d8%af/" target="_blank">این آموزش (روی این متن کلیک کنید)</a> شورتکد المنتور را بسازید و در این بخش قرار دهید.
			// 	<br><br> توجه: خرید المنتور پرو اجباری نیست و شما می‌توانید با قرار دادن روی on از هدر پیش فرض قالب استفاده کنید و این بخش را هم خالی بگذارید . این کار صرفا برای کسانی است که حتما می
			// 	‌خواهند یک هدر اختصاصی داشته باشند و می‌توانند المنتور پرو را هم برای طراحی اختصاصی هدر سایت شان، خریداری کنند.', 'hamyarlearn' ),
			// 	'std'          => '',
			// 	'type'         => 'text',
			// 	'section'      => 'general_settings',
			// 	'rows'         => '',
			// 	'post_type'    => '',
			// 	'taxonomy'     => '',
			// 	'min_max_step' => '',
			// 	'class'        => '',
			// 	'condition'    => '',
			// 	'operator'     => 'and',
			// ),
			// array(
			// 	'id'           => 'elementor_footer_on',
			// 	'label'        => esc_html__( 'نمایش فوتر اصلی یا شورتکد المنتور؟', 'hamyarlearn' ),
			// 	'desc'         => esc_html__( 'با on بودن، فوتر اصلی نمایش داده می‌شود و با off بودن، فوتر المنتوری (طراحی شده با شورتکد)<br><br>
			// 	دو نکته‌ی مهم:<br>
			// 	نکته‌ی اول: اگر اولین بار است از این تنظیم استفاده می‌کنید، یکبار off کنید و مجددا on کنید و سپس استفاده کنید.<br>
			// 	نکته‌ی دوم: حتما باید المنتور پرو را خریداری و نصب کرده باشید تا بتوانید از هدر المنتوری استفاده کنید. چون المنتور رایگان، شورتکد ندارد.', 'hamyarlearn' ),
			// 	'std'          => '',
			// 	'type'         => 'on-off',
			// 	'section'      => 'general_settings',
			// 	'rows'         => '',
			// 	'post_type'    => '',
			// 	'taxonomy'     => '',
			// 	'min_max_step' => '',
			// 	'class'        => '',
			// 	'condition'    => '',
			// 	'operator'     => 'and',
			// ),
			// array(
			// 	'id'           => 'elementor_shortcode_footer',
			// 	'label'        => esc_html__( 'شورتکد المنتور فوتر', 'hamyarlearn' ),
			// 	'desc'         => esc_html__( 'اگر روی OFF قرار دادید، در این بخش باید شورتکد المنتور خود را وارد کنید.<br><br>
			// 	<span style="color:red;">حتما باید المنتور پرو را خریداری و روی این سایت‌تان، نصب کرده باشید.</span><br>
			// 	با کمک <a href="https://elementorfa.ir/%d9%86%d9%85%d8%a7%db%8c%d8%b4-%d9%82%d8%a7%d9%84%d8%a8-%d9%87%d8%a7%db%8c-%d8%a7%d9%84%d9%85%d9%86%d8%aa%d9%88%d8%b1-%d8%a8%d8%a7-%d8%b4%d9%88%d8%b1%d8%aa-%da%a9%d8%af/" target="_blank">این آموزش (روی این متن کلیک کنید)</a> شورتکد المنتور را بسازید و در این بخش قرار دهید.
			// 	<br><br> توجه: خرید المنتور پرو اجباری نیست و شما می‌توانید با قرار دادن روی on از فوتر پیش فرض قالب استفاده کنید و این بخش را هم خالی بگذارید . این کار صرفا برای کسانی است که حتما می
			// 	‌خواهند یک فوتر اختصاصی داشته باشند و می‌توانند المنتور پرو را هم برای طراحی اختصاصی فوتر سایت شان، خریداری کنند.', 'hamyarlearn' ),
			// 	'std'          => '',
			// 	'type'         => 'text',
			// 	'section'      => 'general_settings',
			// 	'rows'         => '',
			// 	'post_type'    => '',
			// 	'taxonomy'     => '',
			// 	'min_max_step' => '',
			// 	'class'        => '',
			// 	'condition'    => '',
			// 	'operator'     => 'and',
			// ),
			array(
				'id'           => 'tooman_enable',
				'label'        => esc_html__( 'فعالسازی کد واحد پولی تومان برای افزونه‌ی لرن‌پرس', 'hamyarlearn' ),
				'desc'         => esc_html__( '<strong>توصیه‌ی ما: فعال باشد.</strong><br> برای فعالسازی، یکبار غیرفعال کنید و سپس on کنید.<br>
				اگر غیرفعال کردید، از افزونه‌ی زرین‌پال لرن‌پرس در سایت خود زرین‌پال، به جای فایل افزونه اصلاح شده در پکیج قالب دانلود شده استفاده کنید<br>
				در صورتی هم که فعال کردید، حتما افزونه‌ی زرین‌پال اصلاح‌شده (برای واحد پولی تومان) را روی سایت‌تان نصب کنید.
				این افزونه، در پکیج فایل قالب دانلود شده، موجود است و باید نصب و فعال کنید.<br>
				در صورتی هم که کلا افزونه‌ی لرن‌پرس را نصب و فعال نکرده‌اید و به آن نیازی هم ندارید، این افزونه را پاک کنید. این تنظیم هم در این صورت، کاری نمی‌کند.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'general_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'enable_user_register_date',
				'label'        => esc_html__( 'فعالسازی نمایش تاریخ عضویت کاربر در بخش کاربران', 'hamyarlearn' ),
				'desc'         => esc_html__( 'با این تنظیم، در پیشخوان وردپرس > کاربران، یک ستون جدید با عنوان
				 تاریخ عضویت کاربر
				 اضافه می‌شود.<br>
				 <strong style="color:red">
				 نکته‌ی مهم: این تاریخ بصورت میلادی نمایش داده خواهد شد.
				 </strong>', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'general_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'enable_mobile_menu_search',
				'label'        => esc_html__( 'فعال بودن باکس جستجو در منوی موبایل', 'hamyarlearn' ),
				'desc'         => esc_html__( 'با فعالسازی این تنظیم، در منوی موبایل سایت باکس جستجو اضافه می‌شود.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'general_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'author_learndash_enable',
				'label'        => esc_html__( 'فعال بودن نویسنده (مدرس اصلی) دوره در پایین دوره برای لرن دش', 'hamyarlearn' ),
				'desc'         => esc_html__( 'قالب همیار لرن، یک باکس نویسنده به پایین صفحه‌ی دوره‌ی لرن دش اضافه می‌کند.<br>
				همان طور که می‌دانید، نصب افزونه لرن دش برای قالب همیار لرن، ضروری نیست و فقط در صورت نیاز است و قالب همیار لرن هم با آن سازگار است.
				اگر نصب دارید، این تنظیم برای شما کار می‌کند و در صورتی که نصب نیست، این تنظیم کلا کار نمیکند!', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'general_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'left_sidr',
				'label'        => esc_html__( 'فعالسازی باز شدن منوی موبایل از سمت راست', 'hamyarlearn' ),
				'desc'         => esc_html__( 'به طور پیش فرض منوی موبایل از سمت چپ باز می‌شود.<br>
				با فعال کردن این تنظیم، منوی موبایل از سمت راست باز می‌شود.
				توصیه‌ی ما، این است که از همان سمت چپ باز شود. ولی در صورتی که حتما می‌خواهید از سمت درخواست
				 باز شود، مشکلی نیست و میتوانید این تنظیم را فعال کنید.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'general_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			//
//
			//shtemplates_settings
//
			array(
				'id'           => 'type_of_bg_header',
				'label'        => esc_html__( 'نوع بک گراند بالای صفحات سایت را مشخص کنید', 'hamyarlearn' ),
				'desc'         => esc_html__( 'دموی نوع اول: <a href="https://cdn.zhaket.com/resources/5dca2013eaec37000920809f/5e2c016d80ce3b009d22a50d.png" target="_blank">روی من کلیک کن!</a><br>
				دموی نوع دوم: <a href="https://cdn.zhaket.com/resources/5dca2013eaec37000920809f/5e2c016ef0805900a0755e2b.png" target="_blank">روی من کلیک کن!</a><br>
				دموی نوع سوم: <a href="https://cdn.zhaket.com/resources/5dca2013eaec37000920809f/5e2c016e68cea800ad0844c7.png" target="_blank">روی من کلیک کن!</a><br>
				دموی بدون بک گراند: <a href="https://cdn.zhaket.com/resources/5dca2013eaec37000920809f/5e2c016f7d86e800af76eda8.png" target="_blank">روی من کلیک کن!</a><br>', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'select',
				'section'      => 'shtemplates_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
				'choices'      => array(
					array(
						'value' => 'bg_first',
						'label' => esc_html__( 'نوع اول', 'hamyarlearn' ),
						'src'   => '',
					),
					array(
						'value' => 'bg_second',
						'label' => esc_html__( 'نوع دوم', 'hamyarlearn' ),
						'src'   => '',
					),
					array(
						'value' => 'bg_third',
						'label' => esc_html__( 'نوع سوم', 'hamyarlearn' ),
						'src'   => '',
					),
					array(
						'value' => 'bg_no',
						'label' => esc_html__( 'بدون بک گراند', 'hamyarlearn' ),
						'src'   => '',
					),
				),
			),
			array(
				'id'           => 'default_template_posts',
				'label'        => esc_html__( 'قالب پیش فرض صفحه‌ی نوشته‌ها', 'hamyarlearn' ),
				'desc'         => esc_html__( 'شما می‌توانید برای هر نوشته هم، این مورد را تنظیم کنید. برای این کار، روی ویرایش نوشته کلیک کنید.
				 سپس در سایدبار سمت چپ آن، از بخش ویژگی‌های نوشته > قالب، روی گزینه‌ی مد نظر خود کلیک کنید.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'select',
				'section'      => 'shtemplates_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
				'choices'      => array(
					array(
						'value' => 'noside',
						'label' => esc_html__( 'بدون ساید بار', 'hamyarlearn' ),
						'src'   => '',
					),
					array(
						'value' => 'sidel',
						'label' => esc_html__( 'سایدبار چپ', 'hamyarlearn' ),
						'src'   => '',
					),
					array(
						'value' => 'sider',
						'label' => esc_html__( 'سایدبار راست', 'hamyarlearn' ),
						'src'   => '',
					),
				),
			),
//
//
			array(
				'id'           => 'back_slider',
				'label'        => esc_html__( 'تصویر بک گراند اسلایدر بالای سایت', 'hamyarlearn' ),
				'desc'         => esc_html__( 'می‌توانید تصویری را انتخاب کنید تا در آن‌جا قرار بگیرد.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'slider_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'position_bgimg',
				'label'        => esc_html__( 'مکان نمایش تصویر', 'hamyarlearn' ),
				'desc'         => esc_html__( 'تصویر بک گراند، در راست، چپ یا وسط نمایش داده شود؟', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'select',
				'section'      => 'slider_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
				'choices'      => array(
					array(
						'value' => 'bg_right',
						'label' => esc_html__( 'راست', 'hamyarlearn' ),
						'src'   => '',
					),
					array(
						'value' => 'bg_center',
						'label' => esc_html__( 'وسط', 'hamyarlearn' ),
						'src'   => '',
					),
					array(
						'value' => 'bg_left',
						'label' => esc_html__( 'چپ', 'hamyarlearn' ),
						'src'   => '',
					),
				),
			),
			array(
				'id'           => 'slider_defult_h',
				'label'        => esc_html__( 'متن اصلی سمت چپ اسلایدر', 'hamyarlearn' ),
				'desc'         => esc_html__( 'به جای "بیش از 1000 وبمستر" در صفحه‌ی اصلی', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'slider_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'slider_defult_span',
				'label'        => esc_html__( 'متن فرعی سمت چپ اسلایدر', 'hamyarlearn' ),
				'desc'         => esc_html__( 'به جای "و کسب و کار آنلاین موفق" در صفحه‌ی اصلی', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'slider_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'slider_right_one',
				'label'        => esc_html__( 'متن اصلی سمت راست اسلایدر', 'hamyarlearn' ),
				'desc'         => esc_html__( 'به جای "اینجا شروع آینده موفق شغلی شماست"', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'slider_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'slider_right_two',
				'label'        => esc_html__( 'متن فرعی سمت راست اسلایدر', 'hamyarlearn' ),
				'desc'         => esc_html__( 'به جای "کسب و کار اینترنتی خودتان را راه اندازی کنید"', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'slider_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'slider_right_a',
				'label'        => esc_html__( 'متن دکمه در اسلایدر سمت چپ', 'hamyarlearn' ),
				'desc'         => esc_html__( 'به جای "آموزش کسب و کار اینترنتی"', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'slider_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'slider_button_link',
				'label'        => esc_html__( 'لینک دکمه‌ی اسلایدر', 'hamyarlearn' ),
				'desc'         => esc_html__( 'لینک دکمه‌ی اسلایدر سمت چپ را وارد کنید.
<br>می‌توانید لینک یک برگه، لینک یکی از محصولات برتر و... را قرار دهید.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'slider_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'blog_link',
				'label'        => esc_html__( 'لینک برگه‌ی "وبلاگ"', 'hamyarlearn' ),
				'desc'         => esc_html__( 'لینک برگه‌ی وبلاگ را وارد کنید. (فقط نامک آدرس (یعنی بدون آدرس سایت شما))
<br>مثلا: (فقط به این صورت باشد- بدون آدرس)<br>
blog', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'links_sttings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'shop_link',
				'label'        => esc_html__( 'لینک برگه‌ی "فروشگاه" یا در واقع همان "همه‌ی دوره‌های آموزشی"', 'hamyarlearn' ),
				'desc'         => esc_html__( 'لینک برگه‌ی فروشگاه را وارد کنید. (فقط نامک آدرس (یعنی بدون آدرس سایت شما))
<br>مثلا:<br>
shop', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'links_sttings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'remove_bookarea',
				'label'        => esc_html__( 'عدم نمایش باکس "دانلود کتاب" در صفحه‌ی اصلی', 'hamyarlearn' ),
				'desc'         => esc_html__( 'با انتخاب "ON" نمایش داده می‌شود و <br>
با انتخاب "OFF" نمایش داده <b>نمی‌شود.</b>', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'bookarea_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'book_p',
				'label'        => esc_html__( 'به جای "روایتی واقعی از"', 'hamyarlearn' ),
				'desc'         => '',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'bookarea_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'book_h3',
				'label'        => esc_html__( 'به جای "ساختن کارخانه‌ی پولسازی در ایران"', 'hamyarlearn' ),
				'desc'         => '',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'bookarea_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'book_span',
				'label'        => esc_html__( 'به جای "همین الان رایگان دانلود کنید!!"', 'hamyarlearn' ),
				'desc'         => '',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'bookarea_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'book_button_txt',
				'label'        => esc_html__( 'متن دکمه‌ی "دانلود کتاب"', 'hamyarlearn' ),
				'desc'         => '',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'bookarea_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'book_button_link',
				'label'        => esc_html__( 'لینک دکمه', 'hamyarlearn' ),
				'desc'         => '',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'bookarea_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'book_img',
				'label'        => esc_html__( 'تصویر کتاب', 'hamyarlearn' ),
				'desc'         => esc_html__( 'تصویر سمت چپ از کتاب<br>
سایز مناسب: ارتفاع: 350 در عرض:200 پیکسل', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'bookarea_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'infos_p',
				'label'        => esc_html__( 'به جای "آمار و ارقام نشانگر"', 'hamyarlearn' ),
				'desc'         => '',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'count_home',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'infos_h4',
				'label'        => esc_html__( 'به جای "موفقیت دانشجویان ما"', 'hamyarlearn' ),
				'desc'         => '',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'count_home',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'infos_span',
				'label'        => esc_html__( 'به جای "می باشد"', 'hamyarlearn' ),
				'desc'         => '',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'count_home',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'count_courses',
				'label'        => esc_html__( 'تعداد دوره‌های آموزشی', 'hamyarlearn' ),
				'desc'         => '',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'count_home',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'infos_courses',
				'label'        => esc_html__( 'متن "دوره‌ی آموزشی"', 'hamyarlearn' ),
				'desc'         => '',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'count_home',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'count_hamyaris',
				'label'        => esc_html__( 'تعداد همیارجویان', 'hamyarlearn' ),
				'desc'         => '',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'count_home',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'infos_hamyaris',
				'label'        => esc_html__( 'متن "همیارجو"', 'hamyarlearn' ),
				'desc'         => '',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'count_home',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'count_hours',
				'label'        => esc_html__( 'تعداد ساعات آموزش', 'hamyarlearn' ),
				'desc'         => '',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'count_home',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'infos_hours',
				'label'        => esc_html__( 'متن "ساعت آموزش"', 'hamyarlearn' ),
				'desc'         => '',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'count_home',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'count_oksells',
				'label'        => esc_html__( 'تعداد فارغ التحصیلان', 'hamyarlearn' ),
				'desc'         => '',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'count_home',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'infos_oksells',
				'label'        => esc_html__( 'متن "فارغ التحصیل"', 'hamyarlearn' ),
				'desc'         => '',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'count_home',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'remove_course_intro',
				'label'        => esc_html__( 'حذف باکس "معرفی دوره" از تمام صفحات', 'hamyarlearn' ),
				'desc'         => esc_html__( 'اگر روی ON قرار دهید، نمایش داده می‌شود (اگر در تنظیمات ویرایش محصول این باکس را تنظیم کنید که نمایش دهد ولی در تنظیمات اینجا در تمام صفحات غیرفعال باشد، نمایش نمی‌دهد) و<br>
در صورتی که روی <b>OFF</b> قرار دهید، در تمام صفحات نمایش داده نمی‌شود.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'course_page_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'text_course_intro',
				'label'        => esc_html__( 'متن بخش معرفی دوره', 'hamyarlearn' ),
				'desc'         => 'این بخش را خالی بگذارید تا متن پیش فرض قرار بگیرد.',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'course_page_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'remove_course_lessons',
				'label'        => esc_html__( 'حذف باکس "سرفصل‌های دوره" از تمام صفحات (جدید!!)', 'hamyarlearn' ),
				'desc'         => esc_html__( 'اگر روی ON قرار دهید، نمایش داده می‌شود (اگر در تنظیمات ویرایش محصول این باکس را تنظیم کنید که نمایش دهد ولی در تنظیمات اینجا در تمام صفحات غیرفعال باشد، نمایش نمی‌دهد) و<br>
در صورتی که روی <b>OFF</b> قرار دهید، در تمام صفحات نمایش داده نمی‌شود.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'course_page_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'text_course_lessons',
				'label'        => esc_html__( 'متن بخش سرفصل‌های دوره', 'hamyarlearn' ),
				'desc'         => 'این بخش را خالی بگذارید تا متن پیش فرض قرار بگیرد.',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'course_page_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'remove_course_requirement',
				'label'        => esc_html__( 'حذف باکس "مخاطبین دوره" از تمام صفحات', 'hamyarlearn' ),
				'desc'         => esc_html__( 'اگر روی ON قرار دهید، نمایش داده می‌شود (اگر در تنظیمات ویرایش محصول این باکس را تنظیم کنید که نمایش دهد ولی در تنظیمات اینجا در تمام صفحات غیرفعال باشد، نمایش نمی‌دهد) و<br>
در صورتی که روی <b>OFF</b> قرار دهید، در تمام صفحات نمایش داده نمی‌شود.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'course_page_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'text_course_requirement',
				'label'        => esc_html__( 'متن بخش مخاطبین دوره', 'hamyarlearn' ),
				'desc'         => 'این بخش را خالی بگذارید تا متن پیش فرض قرار بگیرد.',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'course_page_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'remove_course_teachers',
				'label'        => esc_html__( 'حذف باکس "مدرس دوره" از تمام صفحات', 'hamyarlearn' ),
				'desc'         => esc_html__( 'اگر روی ON قرار دهید، نمایش داده می‌شود (اگر در تنظیمات ویرایش محصول این باکس را تنظیم کنید که نمایش دهد ولی در تنظیمات اینجا در تمام صفحات غیرفعال باشد، نمایش نمی‌دهد) و<br>
در صورتی که روی <b>OFF</b> قرار دهید، در تمام صفحات نمایش داده نمی‌شود.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'course_page_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'text_course_teachers',
				'label'        => esc_html__( 'متن بخش مدرس دوره', 'hamyarlearn' ),
				'desc'         => 'این بخش را خالی بگذارید تا متن پیش فرض قرار بگیرد.',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'course_page_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'remove_course_faq',
				'label'        => esc_html__( 'حذف باکس "سوالات متداول" از تمام صفحات (جدید!!!)', 'hamyarlearn' ),
				'desc'         => esc_html__( '<span style="color:#F50057">این المان جدید اضافه شده است. اگر این بخش را فعال کنید، حتما باید المنتور پرو را نصب کرده باشید.</span><br>
				<span style="color:#FFD000; background:#000;">در صورتی که تمایل به استفاده از این المان دارید، یک بار off و مجدد on کنید.</span><br>
				اگر روی ON قرار دهید، نمایش داده می‌شود (اگر در تنظیمات ویرایش محصول این باکس را تنظیم کنید که نمایش دهد ولی در تنظیمات اینجا در تمام صفحات غیرفعال باشد، نمایش نمی‌دهد) و<br>
در صورتی که روی <b>OFF</b> قرار دهید، در تمام صفحات نمایش داده نمی‌شود.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'course_page_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'text_course_faq',
				'label'        => esc_html__( 'متن بخش سوالات متداول (جدید!!)', 'hamyarlearn' ),
				'desc'         => 'این بخش را خالی بگذارید تا متن پیش فرض قرار بگیرد.',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'course_page_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'remove_course_advice',
				'label'        => esc_html__( 'حذف باکس "درخواست مشاوره" از تمام صفحات', 'hamyarlearn' ),
				'desc'         => esc_html__( 'اگر روی ON قرار دهید، نمایش داده می‌شود (اگر در تنظیمات ویرایش محصول این باکس را تنظیم کنید که نمایش دهد ولی در تنظیمات اینجا در تمام صفحات غیرفعال باشد، نمایش نمی‌دهد) و<br>
در صورتی که روی <b>OFF</b> قرار دهید، در تمام صفحات نمایش داده نمی‌شود.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'course_page_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'text_course_advice',
				'label'        => esc_html__( 'متن بخش درخواست مشاوره', 'hamyarlearn' ),
				'desc'         => 'این بخش را خالی بگذارید تا متن پیش فرض قرار بگیرد.',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'course_page_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'text_button_course_advice',
				'label'        => esc_html__( 'متن دکمه‌ی درخواست مشاوره', 'hamyarlearn' ),
				'desc'         => 'این بخش را خالی بگذارید تا متن پیش فرض قرار بگیرد.',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'course_page_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'remove_course_register',
				'label'        => esc_html__( 'حذف باکس "ثبت نام در دوره" از تمام صفحات', 'hamyarlearn' ),
				'desc'         => esc_html__( 'اگر روی ON قرار دهید، نمایش داده می‌شود (اگر در تنظیمات ویرایش محصول این باکس را تنظیم کنید که نمایش دهد ولی در تنظیمات اینجا در تمام صفحات غیرفعال باشد، نمایش نمی‌دهد) و<br>
در صورتی که روی <b>OFF</b> قرار دهید، در تمام صفحات نمایش داده نمی‌شود.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'course_page_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'text_course_register',
				'label'        => esc_html__( 'متن بخش ثبت نام در دوره', 'hamyarlearn' ),
				'desc'         => 'این بخش را خالی بگذارید تا متن پیش فرض قرار بگیرد.',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'course_page_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'text_button_course_register',
				'label'        => esc_html__( 'متن دکمه‌ی اطلاعات ثبت نام', 'hamyarlearn' ),
				'desc'         => 'این بخش را خالی بگذارید تا متن پیش فرض قرار بگیرد.',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'course_page_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'remove_comments',
				'label'        => esc_html__( 'حذف باکس "نظرات/دیدگاه‌ها" از تمام صفحات', 'hamyarlearn' ),
				'desc'         => esc_html__( 'اگر روی ON قرار دهید، نمایش داده می‌شود (اگر در تنظیمات ویرایش محصول این باکس را تنظیم کنید که نمایش دهد ولی در تنظیمات اینجا در تمام صفحات غیرفعال باشد، نمایش نمی‌دهد) و<br>
در صورتی که روی <b>OFF</b> قرار دهید، در تمام صفحات نمایش داده نمی‌شود.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'course_page_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'text_comments',
				'label'        => esc_html__( 'متن بخش دیدگاه‌ها', 'hamyarlearn' ),
				'desc'         => 'این بخش را خالی بگذارید تا متن پیش فرض قرار بگیرد.',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'course_page_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			//post_settings
			array(
				'id'           => 'remove_article_excerpt',
				'label'        => esc_html__( 'عدم نمایش "خلاصه" در صفحه‌ی مقاله', 'hamyarlearn' ),
				'desc'         => esc_html__( 'برای عدم نمایش روی OFF قرار دهید.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'remove_article_img',
				'label'        => esc_html__( 'عدم نمایش "تصویر شاخص نوشته" در صفحه‌ی مقاله', 'hamyarlearn' ),
				'desc'         => esc_html__( 'برای عدم نمایش روی OFF قرار دهید.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'remove_article_advice',
				'label'        => esc_html__( 'عدم نمایش "باکس درخواست مشاوره" در صفحه‌ی مقاله', 'hamyarlearn' ),
				'desc'         => esc_html__( 'برای عدم نمایش روی OFF قرار دهید.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			//color_settings
			array(
				'id'           => 'first_color_wwsh',
				'label'        => esc_html__( 'رنگ اصلی قالب', 'hamyarlearn' ),
				'desc'         => esc_html__( 'رنگ پیش فرض این قالب: "قرمز" - رنگ خودتان را انتخاب کنید.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'color_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'hover_first_color_wwsh',
				'label'        => esc_html__( 'هاور رنگ اصلی قالب', 'hamyarlearn' ),
				'desc'         => esc_html__( 'رنگ هاور یعنی "وقتی موس روی هر المانی (بخشی از سایت، مثل دکمه و...) می‌رود، بک گراند یا رنگ متن آن چه رنگی شود"', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'color_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'second_color_wwsh',
				'label'        => esc_html__( 'رنگ دوم', 'hamyarlearn' ),
				'desc'         => esc_html__( 'رنگ پیش فرض دوم این قالب: "آبی" - رنگ دوم خود را انتخاب کنید. این رنگ برای دکمه ها و... استفاده می‌شود.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'color_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'hover_second_color_wwsh',
				'label'        => esc_html__( 'هاور رنگ دوم', 'hamyarlearn' ),
				'desc'         => '',
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'color_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'inside_fff_000_second',
				'label'        => esc_html__( 'رنگ داخلی برای رنگ سوم', 'hamyarlearn' ),
				'desc'         => esc_html__( 'رنگ سوم، بیشتر برای رنگ بک‌گراند دکمه ها به کار می‌رود.<br>
				 اگر رنگ سوم، تیره است باید رنگ داخلی اش سفید باشد (متن درون دکمه با رنگ بک گراند "رنگ سوم") و اگر روشن است، باید رنگ داخلی اش سیاه باشد.<br><br>
				  اگر روی ON قرار دهید، رنگ داخلی <b>سیاه</b> خواهد بود و در صورتی که روی OFF باشد، <b>سفید</b> انتخاب می‌شود.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'color_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'third_color_wwsh',
				'label'        => esc_html__( 'رنگ سوم', 'hamyarlearn' ),
				'desc'         => esc_html__( 'رنگ پیش فرض سوم این قالب: "زرد" - رنگ سوم خود را انتخاب کنید. این رنگ برای دکمه‌ی هدر و... استفاده می‌شود.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'color_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'hover_third_color_wwsh',
				'label'        => esc_html__( 'هاور رنگ سوم', 'hamyarlearn' ),
				'desc'         => '',
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'color_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'footer_first_color',
				'label'        => esc_html__( 'رنگ اول فوتر', 'hamyarlearn' ),
				'desc'         => esc_html__( 'رنگ اول فوتر را انتخاب کنید. (فوتر دارای دو رنگ است.)', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'color_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'footer_second_color',
				'label'        => esc_html__( 'رنگ دوم فوتر', 'hamyarlearn' ),
				'desc'         => esc_html__( 'رنگ دوم فوتر را انتخاب کنید. (فوتر دارای دو رنگ است.)', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'color_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header-back-color',
				'label'        => esc_html__( 'رنگ بک گراند هدر (جدید!!!)', 'hamyarlearn' ),
				'desc'         => esc_html__( 'رنگ بک گراند هدر را انتخاب کنید. (توصیه می‌شود همان رنگ سفید باشد که حالت پیش فرض هست)', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'color_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'enable_mobile_menu_notice',
				'label'        => esc_html__( 'فعالسازی اعلان منوی موبایل', 'hamyarlearn' ),
				'desc'         => esc_html__( 'در منوی بازشونده در موبایل، گزینه‌ای تبلیغاتی اضافه می‌شود. مثلا تبلیغ دوره‌ی شما یا جشنواره و تخفیف ویژه در آن هفته!', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'menu_notice',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'notic_title',
				'label'        => esc_html__( 'عنوان/توضیحات اصلی اعلان', 'hamyarlearn' ),
				'desc'         => 'در بخش بالایی و به‌عنوان متن اصلی و توضیح اصلی نمایش داده می‌شود.',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'menu_notice',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'notic_btn_txt',
				'label'        => esc_html__( 'متن دکمه‌ی اعلان', 'hamyarlearn' ),
				'desc'         => 'عنوان دکمه‌ی دعوت به اقدام (call to action) برای باز شدن اعلان. (مثلا لینک صفحه‌ی دوره‌ی شما یا غیره باشد)',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'menu_notice',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'notic_btn_link',
				'label'        => esc_html__( 'لینک دکمه‌ی اعلان', 'hamyarlearn' ),
				'desc'         => 'در اینجا هم لینک آن دکمه را وارد کنید. (لینکی که با کلیک روی دکمه، وارد آن می‌شوند)',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'menu_notice',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			//fast_reg_mobile
			array(
				'id'           => 'enable_mobile_fast_reg',
				'label'        => esc_html__( 'فعالسازی دکمه‌ی ثبت‌نام سریع در صفحه‌ی دوره', 'hamyarlearn' ),
				'desc'         => esc_html__( '
				با فعال بودن این تنظیم، در پایین تمام صفحات دوره در سایت شما، دکمه‌ای اضافه می‌شود که کاربر با
				 کلیک روی آن، می‌توانید سریعا به باکس اطلاعات ثبت‌نام در همان صفحه منتقل شود.
				', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'fast_reg_mobile',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'mobile_fast_reg_btn_txt',
				'label'        => esc_html__( 'متن این دکمه', 'hamyarlearn' ),
				'desc'         => 'متن برای این دکمه.<br>
				مثلا: همین الان ثبت‌نام کنید!',
				'std'          => '',
				'type'         => 'text',
				'section'      => 'fast_reg_mobile',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			//
			array(
				'id'           => 'your_css',
				'label'        => esc_html__( 'CSS اختصاصی', 'hamyarlearn' ),
				'desc'         => esc_html__( 'برای اضافه کردن CSS دلخواه و اختصاصی خودتان، لطفا <strong>تنها</strong> از اینجا اقدام کنید.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'textarea-simple',
				'section'      => 'css_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'top_form_p',
				'label'        => esc_html__( 'متن بالای فرم', 'hamyarlearn' ),
				'desc'         => esc_html__( 'متن قبل از فرم.<br>
به جای متن "شما این فرصت را دارید، با تکمیل فرم زیر، قبل از انتخاب دوره آموزشی مناسب خود، از مشاوره رایگان کارشناسان آموزشی مجموعه همیار آکادمی استفاده نمائید."', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'textarea-simple',
				'section'      => 'advice_box',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'first_advice_h',
				'label'        => esc_html__( 'متن اول به جای "مشاوران آموزشی"', 'hamyarlearn' ),
				'desc'         => esc_html__( 'به جای "مشاوران آموزشی" در باکس چپ', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'advice_box',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'second_advice_h',
				'label'        => esc_html__( 'متن دوم به جای "همیار لرن"', 'hamyarlearn' ),
				'desc'         => esc_html__( 'به جای "همیار لرن" در باکس چپ', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'advice_box',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'third_advice_p',
				'label'        => esc_html__( 'متن سوم به جای "پاسخگوی شما هستند"', 'hamyarlearn' ),
				'desc'         => esc_html__( 'به جای "پاسخگوی شما هستند" در باکس چپ', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'advice_box',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'background_style_advice',
				'label'        => esc_html__( 'بک گراند (پس زمینه) باکس چپ', 'hamyarlearn' ),
				'desc'         => esc_html__( 'تصویر بک گراند را انتخاب کنید.
<br>تصویر بک گراند پیش فرض:<br>
آدرس سایت شما +<br>
wp-content/themes/hamyarlearn/img/lightbox_back.jpg', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'advice_box',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'show_number_advice',
				'label'        => esc_html__( 'شماره تماس نمایش داده شود؟', 'hamyarlearn' ),
				'desc'         => esc_html__( 'با انتخاب ON ، نمایش داده می‌شود و با انتخاب OFF ، نمایش داده نمی‌شود.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'advice_box',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'call_number_advice',
				'label'        => esc_html__( 'شماره تماس:', 'hamyarlearn' ),
				'desc'         => esc_html__( 'شماره تماس تان را وارد کنید.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'advice_box',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'phone_link_advice',
				'label'        => esc_html__( 'لینک شماره تماس', 'hamyarlearn' ),
				'desc'         => esc_html__( 'اگر برای مثال شماره تماس شما 02123456 باشد، باید در این بخش به عنوان لینک این عبارت را وارد کنید:<br>
tel://+98 2123456<br>
عبارت بالا را کپی کنید و با شماره‌ خودتان جایگزین کنید. (در واقع باید بدون صفر در اول شماره، شماره تان را بنویسید.)', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'advice_box',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'show_telegram_advice',
				'label'        => esc_html__( 'تلگرام نمایش داده شود؟', 'hamyarlearn' ),
				'desc'         => esc_html__( 'با انتخاب ON ، نمایش داده می‌شود و با انتخاب OFF ، نمایش داده نمی‌شود.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'advice_box',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'telegram_id_advice',
				'label'        => esc_html__( 'تلگرام:', 'hamyarlearn' ),
				'desc'         => esc_html__( 'ID تلگرام تان را وارد کنید.<br>
مثال: t.me/shayanwebcom<br>
نکته: در ابتدا http:// یا https:// را وارد <b>نکنید.</b>', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'advice_box',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'form_saaz',
				'label'        => esc_html__( 'از چه فرم سازی استفاده می‌کنید؟', 'hamyarlearn' ),
				'desc'         => esc_html__( 'فرم ساز خود را برای فرم درخواست مشاوره انتخاب کنید.<br>
در صورتی که گرویتی فرمز را انتخاب کردید: <a href="#setting_advice_gravityforms">من را کلیک کن!!</a><br>
در صورتی که فرم ساز 7 را انتخاب کردید: <a href="#setting_advice_contactform7">من را کلیک کن!!</a><br>
در صورتی که سایر را انتخاب کردید: <a href="#advice_others">من را کلیک کن!!</a><br>
<br><br> توصیه‌ی ما این است که تا جایی که ممکن است، از گرویتی فرمز استفاده کنید چون قالب ما، سازگاری بیشتری با آن دارد و خودتان نیز بسیار راحتتر هستید. اما در غیر این صورت، از فرم ساز7 استفاده کنید که رایگان است . در صورتی که هیچ کدام از این دو فرم‌ساز برای شما قابل استفاده نبود، نهایتا مجبور به استفاده از سایر فرم سازها هستید که باید به شما شورتکد بدهند.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'select',
				'section'      => 'advice_form',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
				'choices'      => array(
					array(
						'value' => 'selected_gravity_advice',
						'label' => esc_html__( 'گرویتی فرمز (Gravity Forms)', 'hamyarlearn' ),
						'src'   => '',
					),
					array(
						'value' => 'selected_form7_advice',
						'label' => esc_html__( 'فرم ساز 7 (Contact Form 7)', 'hamyarlearn' ),
						'src'   => '',
					),
					array(
						'value' => 'selected_others_advice',
						'label' => esc_html__( 'سایر فرم‌سازها...', 'hamyarlearn' ),
						'src'   => '',
					),
				),
			),
			array(
				'id'           => 'advice_gravityforms',
				'label'        => esc_html__( 'ID فرم گرویتی فرمز (GravityForms)', 'hamyarlearn' ),
				'desc'         => esc_html__( '<div style="line-height:25px">
ID فرم گرویتی فرمز.<br>این آی دی را که به صورت عدد است، می‌توانید در باکس قرمز رنگ، هنگام ساختن فرم ببینید. (در بخش بالا نوشته. مثلا:
<span style="background:#D4662C;color:#fff;padding:3px">ID:4</span> )
</div>
<br>
<br>
لینک‌های کاربردی:
<br>
<a href="https://zhaket.com/product/gravity-forms-farsi/" target="_blank">دریافت گرویتی فرمز</a>
<br>
<a href="https://shayanweb.com/soon" target="_blank">فایل درون ریز گرویتی فرمز (فرم نمونه که با درون ریزی کردن این فرم در گرویتی فرمز و وارد کردن آی دی آن در این بخش، فرم را با ظاهری مناسب نمایش می‌دهد)</a>
<br>', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'advice_form',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'advice_contactform7',
				'label'        => esc_html__( 'ID فرم فرم‌ساز 7 (Contact Form 7)', 'hamyarlearn' ),
				'desc'         => esc_html__( 'ID فرم فرم‌ساز 7.<br>این آی دی را که به صورت عدد است، می‌توانید در لیست فرم‌های فرم‌ساز7، در بخش "کدکوتاه" به این صورت نوشته:
<br><br>
<span style="direction:ltr;background:#333;padding:5px;border-radius:5px;color:#fff">
[contact-form-7 id="150" title="name"]
</span><br><br>
که در این کد، نوشته‌ی id="number" وجود دارد. باید number آی دی را بنویسید. (در این فیلد)', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'advice_form',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'advice_others',
				'label'        => esc_html__( 'شورت کد سایر فرم ساز‌ها', 'hamyarlearn' ),
				'desc'         => esc_html__( 'اگر از گرویتی فرمز یا فرم ساز7 استفاده نمی‌کنید (که پیشنهاد ما این است که حتما از این دو مورد استفاده کنید)، می‌توانید از فرم‌سازهای دیگر نیز استفاده کنید، ولی ممکن است مشکلاتی در استایل داشته باشند و فاصله‌های اضافه و... داشته باشند.
<br>
به هر حال، در صورتی که از دیگر فرم ساز ها استفاده می‌کنید، شورتکدی که به شما می‌دهد را وارد کنید. تنها راه نمایش، استفاده از این شورتکد ها است و در صورتی که فرم‌ساز مدنظر شما شورتکد (ShortCode) نمی‌دهد، راهی برای نمایش آن در این بخش وجود ندارد.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'advice_form',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'remove_address_footbox',
				'label'        => esc_html__( 'نمایش آدرس؟', 'hamyarlearn' ),
				'desc'         => esc_html__( 'با انتخاب ON ، نمایش داده می‌شود و با انتخاب OFF ، نمایش داده نمی‌شود.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'footer_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'address_footbox',
				'label'        => esc_html__( 'آدرس:', 'hamyarlearn' ),
				'desc'         => esc_html__( 'آدرس تان را وارد کنید.
<br>
مثلا: تهران، پاسداران، بوستان دوم، خیابان گیلان غربی، بن بست مریم، پلاک ۲، طبقه اول، واحد ۱', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'footer_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'remove_phone_footbox',
				'label'        => esc_html__( 'نمایش شماره تماس؟', 'hamyarlearn' ),
				'desc'         => esc_html__( 'با انتخاب ON ، نمایش داده می‌شود و با انتخاب OFF ، نمایش داده نمی‌شود.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'footer_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'phone_footbox',
				'label'        => esc_html__( 'شماره تماس:', 'hamyarlearn' ),
				'desc'         => esc_html__( 'شماره تماس تان را وارد کنید.
<br>
مثلا:
۰۲۱۷۴۵۵۳۰۰۰', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'footer_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'link_phone_footbox',
				'label'        => esc_html__( 'لینک شماره تماس فوتر', 'hamyarlearn' ),
				'desc'         => esc_html__( 'اگر برای مثال شماره تماس شما 02123456 باشد، باید در این بخش به عنوان لینک این عبارت را وارد کنید:<br>
tel://+98 2123456<br>
عبارت بالا را کپی کنید و با شماره‌ خودتان جایگزین کنید. (در واقع باید بدون صفر در اول شماره، شماره تان را بنویسید.)', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'footer_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'youtube_scoials',
				'label'        => esc_html__( 'لینک یوتیوب', 'hamyarlearn' ),
				'desc'         => esc_html__( 'در صورت خالی گذاشتن این بخش، آیکون یوتیوب نمایش داده نخواهد شد.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'scoials_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'rss_scoials',
				'label'        => esc_html__( 'لینک rss', 'hamyarlearn' ),
				'desc'         => esc_html__( 'در صورت خالی گذاشتن این بخش، آیکون rss نمایش داده نخواهد شد.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'scoials_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'telegram_scoials',
				'label'        => esc_html__( 'لینک تلگرام', 'hamyarlearn' ),
				'desc'         => esc_html__( 'در صورت خالی گذاشتن این بخش، آیکون تلگرام نمایش داده نخواهد شد.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'scoials_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'insta_scoials',
				'label'        => esc_html__( 'لینک اینستاگرام', 'hamyarlearn' ),
				'desc'         => esc_html__( 'در صورت خالی گذاشتن این بخش، آیکون اینستاگرام نمایش داده نخواهد شد.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'scoials_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'google_scoials',
				'label'        => esc_html__( 'لینک گوگل+', 'hamyarlearn' ),
				'desc'         => esc_html__( 'در صورت خالی گذاشتن این بخش، آیکون گوگل+ نمایش داده نخواهد شد.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'scoials_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'twit_scoials',
				'label'        => esc_html__( 'لینک توئیتر', 'hamyarlearn' ),
				'desc'         => esc_html__( 'در صورت خالی گذاشتن این بخش، آیکون توئیتر نمایش داده نخواهد شد.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'scoials_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'face_scoials',
				'label'        => esc_html__( 'لینک فیسبوک', 'hamyarlearn' ),
				'desc'         => esc_html__( 'در صورت خالی گذاشتن این بخش، آیکون فیسبوک نمایش داده نخواهد شد.', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'scoials_settings',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'count_products_in_home',
				'label'        => esc_html__( 'تعداد محصولات در صفحه‌ی اصلی', 'hamyarlearn' ),
				'desc'         => esc_html__( 'چه تعداد محصول در صفحه‌ی اصلی نمایش داده شود؟', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'numeric-slider',
				'section'      => 'count_products',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'count_products_in_archivepros',
				'label'        => esc_html__( 'تعداد محصولات در هر صفحه از آرشیو دوره', 'hamyarlearn' ),
				'desc'         => esc_html__( 'تعداد محصولات در هر صفحه از آرشیو دوره (شامل صفحه‌ی همه‌ی دوره‌ها، آرشیو دسته بندی دوره و...)', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'numeric-slider',
				'section'      => 'count_products',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'footer_codes_wwsh',
				'label'        => esc_html__( 'کدهای خود را اینجا وارد کنید.', 'hamyarlearn' ),
				'desc'         => esc_html__( 'کدهای خود را در اینجا وارد کنید. (کدهای گوگل آنالیتیکس و...)<br>
همچنین برای کدهای <b>جاوا اسکریپت</b> هم می‌توانید از این بخش استفاده کنید. (با باز کردن تگ html برای جاوا اسکریپت، یعنی تگ script - فراموش نکنید که حتما این تگ را ببندید.)', 'hamyarlearn' ),
				'std'          => '',
				'type'         => 'textarea-simple',
				'section'      => 'footer_wwsh_codes',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
		)
	);

	// Allow settings to be filtered before saving.
	$custom_settings = apply_filters( ot_settings_id() . '_args', $custom_settings );

	// Settings are not the same update the DB.
	if ( $saved_settings !== $custom_settings ) {
		update_option( ot_settings_id(), $custom_settings );
	}

	// Lets OptionTree know the UI Builder is being overridden.
	global $ot_has_custom_theme_options;
	$ot_has_custom_theme_options = true;
}
