<?php
namespace Elementor;

class hm_form_shortcode extends Widget_Base
{
    public function get_name()
    {
        return 'hm_form_shortcode';
    }
    public function get_title()
    {
        return __('قرار دادن فرم', 'hamyarlearn');
    }
    public function get_icon()
    {
        return 'eicon-form-horizontal';
    }
    public function get_categories()
    {
        return [ 'HL-Elements' ];
    }
    protected function _register_controls()
    {
        //start section control (tab:content)
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'hamyarlearn'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'note_about_woo_title',
			[
				'label' => __( 'توضیحاتی در مورد این المان', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw' => __( '<div style="font-size:16px; color:#fff; border-radius:10px; padding:10px; line-height:1.9; display:block; background:#F50057; font-weight:500;">این المان، برای قالب همیار لرن می‌باشد.<br>
        با کمک این المان، براحتی در صفحات مختلف، فرم قرار دهید و با استایل مناسبی نمایش دهید!<br>
        قابل استفاده برای:<br>
        <ul>
          <li>
          گرویتی فرمز
          </li>
          <li>
          فرم تماس 7
          </li>
        </ul>
        </div>', 'hamyarlearn' ),
				'content_classes' => 'element_title_note',
			]
		);

    $this->add_control(
        'form_builder',
        [
            'label' => __('انتخاب فرم‌ساز', 'hamyarlearn'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'contact7',
            'options' => [
                'contact7'  => __('فرم تماس 7', 'hamyarlearn'),
                'gravity' => __('گرویتی فرمز', 'hamyarlearn'),
                'other' => __('دیگر... (با شورتکد)', 'hamyarlearn'),
            ],
        ]
    );

    $this->add_control(
			'otherform_note',
			[
				'label' => __( 'نکته‌ای در مورد دیگر فرم‌سازها', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw' => __( '
        <div style="font-size:16px; color:#fff; border-radius:10px; padding:10px; line-height:1.9; display:block; background:#3D5AFE; font-weight:500;">
        توجه داشته باشید که با استفاده از یک فرم‌ساز دیگر، ممکن است استایل‌ها به هم بخورد یا اعمال نشود.
        </div>', 'hamyarlearn' ),
        'condition' => [
            'form_builder' => 'other',
        ],
				'content_classes' => '',
			]
		);

    $this->add_control(
			'form_builder_shortcode',
			[
				'label' => __( 'شورتکد فرم', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'placeholder' => __( '[contact-form-7 id="1" title="name"]', 'hamyarlearn' ),
			]
		);

    $this->add_control(
			'note_gravcon7',
			[
				'label' => __( 'یادداشت شورتکد گرویتی فرمز و فرم‌تماس 7', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw' => __( '
        <div style="font-size:16px; color:#333; border-radius:10px; padding:10px; line-height:1.9; display:block; background:#f5f5f5; font-weight:500;">
        برای شورتکد فرم‌ساز 7 از کد زیر بطور پیش‌فرض استفاده می‌شود:<br>
        (البته توجه داشته باشید که این مورد فقط برای افرادی که به این ساختار شورتکد آشنایی دارند مناسب است.
         اگر اطلاعی ندارید، به تنظیمات افزونه رفته و شورتکد را پیدا کنید.)
        <br>
        [contact-form-7 id="1" title="name"]
        <br>
        <br>
        برای شورتکد گرویتی فرمز، از کد زیر بطور پیش‌فرض استفاده می‌شود:<br>
        (البته توجه داشته باشید که این مورد فقط برای افرادی که به این ساختار شورتکد آشنایی دارند مناسب است.
         اگر اطلاعی ندارید، برای پیدا کردن شورتکد گرویتی فرمز، این لینک را ببینید:
        <a href="https://mashhadcode.com/3435/gravity-forms-edu/" target="_blank">لینک!</a>
        <br>
        [gravityform id="1" title="false" description="false" ajax="true"]
        </div>
        ', 'hamyarlearn' ),
				'content_classes' => '',
			]
		);

		$this->end_controls_section();

    		$this->end_controls_section();

        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل نمایش فرم', 'hamyarlearn' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

    $this->add_control(
			'fields_text_align',
			[
				'label' => __( 'جهت متن فیلدهای فرم', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
          'right' => [
						'title' => __( 'راست', 'hamyarlearn' ),
						'icon' => 'fa fa-align-right',
					],
					'center' => [
						'title' => __( 'وسط', 'hamyarlearn' ),
						'icon' => 'fa fa-align-center',
					],
          'left' => [
						'title' => __( 'چپ', 'hamyarlearn' ),
						'icon' => 'fa fa-align-left',
					],
				],
				'default' => 'right',
				'toggle' => true,
			]
		);

    $this->add_control(
			'submit_field_text_align',
			[
				'label' => __( 'جهت متن فیلد ارسال در فرم', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
          'right' => [
						'title' => __( 'راست', 'hamyarlearn' ),
						'icon' => 'fa fa-align-right',
					],
					'center' => [
						'title' => __( 'وسط', 'hamyarlearn' ),
						'icon' => 'fa fa-align-center',
					],
          'left' => [
						'title' => __( 'چپ', 'hamyarlearn' ),
						'icon' => 'fa fa-align-left',
					],
				],
        'condition' => [
            'form_builder' => 'contact7',
        ],
				'default' => 'center',
				'toggle' => true,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'submit_btn_typing',
				'label' => __( 'تایپوگرافی دکمه‌ی ارسال', 'hamyarlearn' ),
				'selector' => '{{WRAPPER}} .hml-contact-form input[type="submit"]',
			]
		);

    $this->add_control(
			'submit_btn_color_contact7',
			[
				'label' => __( 'رنگ متن دکمه‌ی ارسال', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .hml-contact-form input[type="submit"]' => 'color: {{VALUE}}',
				],
        'condition' => [
            'form_builder' => 'contact7',
        ],
			]
		);

    $this->add_control(
			'submit_btn_color_grav',
			[
				'label' => __( 'رنگ متن دکمه‌ی ارسال', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .hml-contact-form .gform_footer input[type="submit"].gform_button.button' => 'color: {{VALUE}} !important',
				],
        'condition' => [
            'form_builder' => 'gravity',
        ],
			]
		);

    $this->add_control(
			'submit_btn_bgcolor_contact7',
			[
				'label' => __( 'رنگ پس‌زمینه‌ی دکمه‌ی ارسال', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#f22d33',
				'selectors' => [
					'{{WRAPPER}} .hml-contact-form input[type="submit"]' => 'background: {{VALUE}}; box-shadow: 0 2px 20px {{VALUE}}',
				],
        'condition' => [
            'form_builder' => 'contact7',
        ],
			]
		);


    $this->add_control(
			'submit_btn_bgcolor_grav',
			[
				'label' => __( 'رنگ پس‌زمینه‌ی دکمه‌ی ارسال', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#f22d33',
				'selectors' => [
					'{{WRAPPER}} .hml-contact-form .gform_footer input[type="submit"].gform_button.button' => 'background: {{VALUE}} !important; box-shadow: 0 2px 20px {{VALUE}} !important',
				],
        'condition' => [
            'form_builder' => 'gravity',
        ],
			]
		);

    $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'fields_typing',
				'label' => __( 'تایپوگرافی متن فیلدها', 'hamyarlearn' ),
				'selector' => '{{WRAPPER}} .hml-contact-form input[type="text"], .hml-contact-form input[type="email"], .hml-contact-form input[type="tel"]',
			]
		);

    $this->add_control(
			'fields_color',
			[
				'label' => __( 'رنگ متن فیلدها', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#333',
				'selectors' => [
					'{{WRAPPER}} .hml-contact-form input[type="text"], .hml-contact-form input[type="email"], .hml-contact-form input[type="tel"]' => 'color: {{VALUE}}',
				],
			]
		);

    $this->end_controls_section();

    }

    protected function render(){
      $settings = $this->get_settings_for_display();
      $element_ID = $this->get_id();
      //
      $formshortcode = $settings['form_builder_shortcode'];
      ?>

      <div class="<?php echo "shwebform-$element_ID"; ?> hml-contact-form">
        <?php echo do_shortcode($formshortcode); ?>
      </div>

      <style media="screen">
        <?php echo ".shwebform-$element_ID"; ?>.hml-contact-form , <?php echo ".shwebform-$element_ID"; ?>.hml-contact-form input{
          <?php
          if (!$settings['fields_text_align']) {
            $shweb_align = 'right';
          }else {
            $shweb_align = $settings['fields_text_align'];
          }
          echo 'text-align:' . $shweb_align ;
          ?>;
        }

        <?php echo ".shwebform-$element_ID"; ?>.hml-contact-form input[type="submit"]{
          <?php
          if (!$settings['submit_field_text_align']) {
            $shweb_align = 'center';
          }else {
            $shweb_align = $settings['submit_field_text_align'];
          }
          echo 'text-align:' . $shweb_align ;
          ?>;
        }
      </style>

  <?php } }
