<?php
namespace Elementor;
class hm_customers extends Widget_Base {
	public function get_name() {
		return 'hm_customers';
	}
	public function get_title() {
		return __( 'مشتریان همیار لرن', 'hamyarlearn' );
	}
	public function get_icon() {
		return 'eicon-blockquote';
	}
	public function get_categories() {
		return [ 'HL-Elements' ];
	}

	protected function _register_controls() {
    //start section control (tab:content)
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'hamyarlearn' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'list_content', [
				'label' => __( 'محتوا', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => __( 'من از شرکت در دوره‌های آموزشی وبسایت شایان وب، بسیار راضی هستم! محتوا بسیار کامل و مناسب است و اساتید کاملا مسلط هستند.' , 'hamyarlearn' ),
				'show_label' => false,
			]
		);

		$repeater->add_control(
			'list_title', [
				'label' => __( 'نام مشتری', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'شایان فرهنگ پژوه' , 'hamyarlearn' ),
				'label_block' => true,
			]
		);


		$repeater->add_control(
			'cust_subname', [
				'label' => __( 'توضیح کوتاه مشتری', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'بنیانگذار مجموعه‌ی شایان وب' , 'hamyarlearn' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'cust_img',
			[
				'label' => __( 'تصویر مشتری', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'cust_is_link',
			[
				'label' => __( 'فعالسازی لینک', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'فعال', 'hamyarlearn' ),
				'label_off' => __( 'غیرفعال', 'hamyarlearn' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$repeater->add_control(
			'cust_link',
			[
				'label' => __( 'لینک این جعبه‌ی مشتری', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( 'https://shayanweb.com/', 'hamyarlearn' ),
				'show_external' => true,
				'default' => [
					'url' => 'https://shayanweb.com/',
					'is_external' => true,
					'nofollow' => false,
				],
				'condition' => [
					'cust_is_link' => 'yes',
				],
			]
		);

		$repeater->add_control(
			'cust_seetitle', [
				'label' => __( 'متن جایگزین مشاهده', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'مشاهده' , 'hamyarlearn' ),
				'label_block' => true,
				'condition' => [
					'cust_is_link' => 'yes',
				],
			]
		);


		$this->add_control(
			'list',
			[
				'label' => __( 'مشتریان و نظرات مشتریان:', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_title' => __( 'شایان فرهنگ پژوه', 'hamyarlearn' ),
					],
					[
						'list_title' => __( 'مشتری تستی همیار لرن', 'hamyarlearn' ),
					],
				],
				'title_field' => '{{{ list_title }}}',
			]
		);

// finish repeter for show customers

		$this->add_control(
			'title_for_carousel_options',
			[
				'label' => __( 'تنظیمات کروسل', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		// $this->add_control(
		// 	'cl_id',
		// 	[
		// 		'label' => __( 'آی‌دی کروسل (ضروری)', 'hamyarlearn' ),
		// 		'type' => \Elementor\Controls_Manager::TEXT,
		// 		'default' => '',
		// 		'placeholder' => __( 'الزامی است', 'hamyarlearn' ),
		// 	]
		// );

		// $this->add_control(
		// 	'note_require_id',
		// 	[
		// 		'label' => '',
		// 		'type' => \Elementor\Controls_Manager::RAW_HTML,
		// 		'raw' => __( '
		// 		<div style="line-height:1.9;">
		// 		<strong>نکات در مورد آی‌دی:</strong>
		// 		<br>
		// 		<ol>
		// 			<li>وارد کردن این فیلد الزامی است.</li>
		// 			<li>این آی‌دی، باید یونیک باشد. (متفاوت باشد و قبلا وارد نکرده باشید)</li>
		// 			<li>تنها موارد مجاز: تنها می‌تواند شامل حروف انگلیسی باشد. بدون فاصله باشد.</li>
		// 			<li></li>
		// 		</ol>
		// 		</div>', 'hamyarlearn' ),
		// 		'content_classes' => 'carousel-status',
		// 	]
		// );


		$this->add_control(
			'cl_loop',
			[
				'label' => __( 'فعال بودن لوپ تکرار', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'فعال', 'hamyarlearn' ),
				'label_off' => __( 'غیرفعال', 'hamyarlearn' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);


		$this->add_control(
			'cl_autoplay',
			[
				'label' => __( 'پخش خودکار', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'فعال', 'hamyarlearn' ),
				'label_off' => __( 'غیرفعال', 'hamyarlearn' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'cl_loop' => 'yes',
				],
			]
		);

		$this->add_control(
			'cl_autoplay_time',
			[
				'label' => __( 'زمان پخش خودکار (به میلی‌ثانیه)', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 100,
				'max' => 120000,
				'step' => 100,
				'default' => 5000,
				'condition' => [
					'cl_loop' => 'yes',
					'cl_autoplay' => 'yes',
				],
			]
		);


		$this->add_control(
			'cl_autoplay_hover',
			[
				'label' => __( 'توقف حرکت در هاور (برای پخش خودکار)', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'فعال', 'hamyarlearn' ),
				'label_off' => __( 'غیرفعال', 'hamyarlearn' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'cl_loop' => 'yes',
					'cl_autoplay' => 'yes',
				],
			]
		);

    $this->end_controls_section();

    $this->start_controls_section(
      'style_section',
      [
    'label' => __( 'استایل باکس مشتری', 'hamyarlearn' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

		$this->add_control(
			'style_custbox_title',
			[
				'label' => __( 'تنظیمات ظاهر نام مشتری', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

    $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'تایپوگرافی نام مشتری', 'hamyarlearn' ),
				'scheme' => Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .customer-item .every-cust .footer-cust .title-cust strong',
			]
		);

    $this->add_control(
			'title_color',
			[
				'label'   => __( 'رنگ نام مشتری', 'hamyarlearn' ),
				'type'    => \Elementor\Controls_Manager::COLOR,
				'default' => '#333',
				'selectors' =>
				[
					'{{WRAPPER}} .customer-item .every-cust .footer-cust .title-cust strong' => 'color: {{VALUE}}'
				],
			]
		);

		$this->add_control(
			'style_custbox_subtitle',
			[
				'label' => __( 'تنظیمات ظاهر توضیح کوتاه مشتری', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'subtitle_typography',
				'label' => __( 'تایپوگرافی توضیح کوتاه مشتری', 'hamyarlearn' ),
				'scheme' => Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .customer-item .every-cust .footer-cust .title-cust span',
			]
		);

		$this->add_control(
			'subtitle_color',
			[
				'label'   => __( 'رنگ توضیح کوتاه مشتری', 'hamyarlearn' ),
				'type'    => \Elementor\Controls_Manager::COLOR,
				'default' => '#333',
				'selectors' =>
				[
					'{{WRAPPER}} .customer-item .every-cust .footer-cust .title-cust span' => 'color: {{VALUE}}'
				],
			]
		);



    $this->add_control(
			'style_custbox_content',
			[
				'label' => __( 'تنظیمات ظاهر متن دیدگاه مشتری', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

    $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'label' => __( 'تایپوگرافی متن دیدگاه مشتری', 'hamyarlearn' ),
				'scheme' => Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .customer-item .every-cust .header-cust',
			]
		);

    $this->add_control(
			'content_color',
			[
				'label'   => __( 'رنگ متن دیدگاه مشتری', 'hamyarlearn' ),
				'type'    => \Elementor\Controls_Manager::COLOR,
				'default' => '#333',
				'selectors' =>
				[
					'{{WRAPPER}} .customer-item .every-cust .header-cust' => 'color: {{VALUE}}'
				]
			]
		);

    $this->add_control(
			'style_custbox_all',
			[
				'label' => __( 'تنظیمات باکس مشتری', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

    $this->add_control(
			'backcolor_custbox',
			[
				'label'   => __( 'رنگ پس‌زمینه', 'hamyarlearn' ),
				'type'    => \Elementor\Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' =>
				[
					'{{WRAPPER}} .customer-item .every-cust' => 'background: {{VALUE}}'
				]
			]
		);

		$this->end_controls_section();

	}

  protected function render() {
  $settings = $this->get_settings_for_display();
	$element_ID = 'owl-cust-'.$this->get_id();




	if ( $settings['list'] ) {
?>

	<div class="owl-carousel <?php echo $element_ID; ?> pros colswpsh">
		<?php
		//start
		foreach (  $settings['list'] as $item ) {
		?>
		<div class="customer-item <?php echo 'custbox-'.$item['_id']; ?>">
			<div class="every-cust">
				<?php
				if ($item['cust_is_link'] === "yes") {
				$target = $item['cust_link']['is_external'] ? ' target="_blank"' : '';
				$nofollow = $item['cust_link']['nofollow'] ? ' rel="nofollow"' : '';
				echo '<a href="' . $item['cust_link']['url'] . '"' . $target . $nofollow . '>';
				}
				?>
					<div class="header-cust">
							<?php echo $item['list_content']; ?>
					</div>
					<div class="footer-cust">
						<div class="row" style="display:flex;align-items:center">
							<div class="col-4">
								<div class="img-cust pull-right">
									<?php
											echo '<img src="' . $item['cust_img']['url'] . '">'; ?>
								</div>
							</div>
							<?php if ($item['cust_is_link'] === "yes") { ?>
							<div class="col-lg-5 col-8">
							<?php }else{ ?>
							<div class="col-8">
							<?php } ?>
								<div class="title-cust pull-right">
									<strong class="d-block">
										<?php echo $item['list_title']; ?>
									</strong>
									<span class="d-block">
										<?php echo $item['cust_subname']; ?>
									</span>
								</div>
							</div>
							<?php if ($item['cust_is_link'] === "yes") { ?>
							<div class="col-3 d-none d-lg-block">
								<div class="see-cust pull-left text-center">
									<div class="seebox">
										<img class="img-see" src="<?php echo get_template_directory_uri() . '/img/eye.svg'; ?>" alt="">
										<span><?php echo $item['cust_seetitle']; ?></span>
									</div>
								</div>
							</div>
							<?php } ?>
						</div>
					</div>
					<?php if ($item['cust_is_link'] === "yes") { ?>
					</a>
					<?php } ?>
			</div>
		</div>
		<?php } //end ?>
	</div>

	<script type="text/javascript">
	jQuery(document).ready(function() {
	jQuery(".<?php echo $element_ID; ?>").owlCarousel({
		<?php if ( is_rtl() ) { ?>
		'rtl': true,
		<?php } ?>
		'item': <?php
		echo "2";
		?>,
		'loop': <?php
		if ( 'yes' === $settings['cl_loop'] ) {
			echo "true";
		}else {
			echo "false";
		}
		?>,
		'lazyLoad': true,
		<?php if ( 'yes' === $settings['cl_loop'] ) { ?>
		'autoplay': <?php
		if ( 'yes' === $settings['cl_autoplay'] ) {
			echo "true";
		}else {
			echo "false";
		}
		?>,
		<?php
		//
		if ( 'yes' === $settings['cl_autoplay'] ) { ?>
		'autoplayTimeout': <?php
		echo $settings['cl_autoplay_time'];
		?>,
		'autoplayHoverPause': <?php
		if ( 'yes' === $settings['cl_autoplay_hover'] ) {
			echo "true";
		}else {
			echo "false";
		}
		?>,
		<?php }
		}
		// ?>
		'nav': <?php
		echo "false";
		?>,
		'dots': <?php echo "false"; ?>,
		responsive: {
			0 : {
				items: 1,
			},
			768 : {
				items: 2,
			},
		}
	});
	});
	</script>


<?php } ?>

      <div class="clear"></div>
  <?php
}
}
