<?php
namespace Elementor;

class hm_PE_FAQ extends Widget_Base
{
    public function get_name()
    {
        return 'hm_PE_FAQ';
    }
    public function get_title()
    {
        return __('سوالات متداول', 'hamyarlearn');
    }
    public function get_icon()
    {
        return 'eicon-post-list';
    }
    public function get_categories()
    {
        return [ 'HL-Products-Elements' ];
    }
    protected function _register_controls()
    {
        //start section control (tab:content)
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'hamyarlearn'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

    		$repeater->add_control(
    			'list_title', [
    				'label' => __( 'عنوان سوال', 'hamyarlearn' ),
    				'type' => \Elementor\Controls_Manager::TEXT,
    				'default' => __( 'آیا قیمت این دوره مناسب است؟' , 'hamyarlearn' ),
    				'label_block' => true,
    			]
    		);

        $repeater->add_control(
    			'list_content', [
    				'label' => __( 'محتوای پاسخ سوال', 'hamyarlearn' ),
    				'type' => \Elementor\Controls_Manager::WYSIWYG,
    				'default' => __( 'مبلغ شرکت در این دوره کمتر از هزینه ای است که شما برای طراحی یک سایت باید پرداخت نمایید با این تفاوت که با این آموزش میتوانید هرچقدر وب‌سایت که خواستید طراحی نمایید. در ضمن مبلغی که شما بابت این آموزش پرداخت می‌نمایید کم ریسک ترین سرمایه گذاری است که انجام می‌دهید، یعنی سرمایه گذاری روی خودتان است.' , 'hamyarlearn' ),
    				'show_label' => false,
    			]
    		);

    	$this->add_control(
    			'list',
    			[
    				'label' => __( 'سوالات متداول' , 'hamyarlearn' ),
    				'type' => \Elementor\Controls_Manager::REPEATER,
    				'fields' => $repeater->get_controls(),
    				'default' => [
    					[
    						'list_title' => __( 'آیا قیمت این دوره مناسب است؟', 'hamyarlearn' ),
                'list_content' => __( 'مبلغ شرکت در این دوره کمتر از هزینه ای است که شما برای طراحی یک سایت باید پرداخت نمایید با این تفاوت که با این آموزش میتوانید هرچقدر وب‌سایت که خواستید طراحی نمایید. در ضمن مبلغی که شما بابت این آموزش پرداخت می‌نمایید کم ریسک ترین سرمایه گذاری است که انجام می‌دهید، یعنی سرمایه گذاری روی خودتان است.' , 'hamyarlearn' ),
    					],
    					[
                'list_title' => __( 'من یک مغازه دارم، میتوانم در این دوره شرکت نمایم؟', 'hamyarlearn' ),
                'list_content' => __( 'بله میتوانید در جهت توسعه کسب و کار سنتی خود در این دوره شرکت نمایید و به راحتی بازدهی کاری و درآمدی خود را چندین برابر نمائید.' , 'hamyarlearn' ),
    					],
              [
                'list_title' => __( 'آیا این‌ مباحث همیشه در خاطر ما خواهد ماند؟', 'hamyarlearn' ),
                'list_content' => __( 'نخبگان وبمستر در دوره وبمستران هوشمند می‌توانند تمامی این اطلاعات را در خاطر بسپارند ولی بهتر است یادداشت برداری و مرور در هر دوره حداکثر یکساله انجام شود.با بکارگیری این روند میتوانند تبدیل به نخبگان وبمستر 5 ستاره شوند' , 'hamyarlearn' ),
    					],
    				],
    				'title_field' => '{{{ list_title }}}',
    			]
    		);

    // finish repeter for show lessons list

    		$this->end_controls_section();

        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل سوالات متداول', 'hamyarlearn' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'PE_question_title_typography',
				'label' => __( 'تایپوگرافی متن سوال', 'hamyarlearn' ),
				'selector' => '{{WRAPPER}} .faqcard button.btn-link',
			]
		);

    $this->add_control(
			'PE_question_title_color',
			[
				'label' => __( 'رنگ متن سوال', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#333',
				'selectors' => [
					'{{WRAPPER}} .faqcard .card-header button.btn-link' => 'color: {{VALUE}} !important',
				],
			]
		);

    $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'PE_answer_typography',
				'label' => __( 'تایپوگرافی پاسخ سوال', 'hamyarlearn' ),
				'selector' => '{{WRAPPER}} .faqcard .card-body',
			]
		);

    $this->add_control(
			'PE_answer_color',
			[
				'label' => __( 'رنگ پاسخ سوال', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#333',
				'selectors' => [
					'{{WRAPPER}} .faqcard .card-body' => 'color: {{VALUE}}',
				],
			]
		);

    $this->add_control(
			'PE_bgcolor_boxes',
			[
				'label' => __( 'رنگ آیکون فعال', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#F50057',
				'selectors' => [
					'{{WRAPPER}} .faqcard button.btn-link:before' => 'color: {{VALUE}}',
				],
			]
		);

    $this->add_control(
      'PE_bgcolor_boxes',
      [
        'label' => __( 'رنگ آیکون غیرفعال', 'hamyarlearn' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#F50057',
        'selectors' => [
          '{{WRAPPER}} .faqcard button.btn-link.collapsed:before' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
			'PE_bgcolor_boxes',
			[
				'label' => __( 'رنگ کادر پایینی', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#e5e5e5',
				'selectors' => [
					'{{WRAPPER}} .faqcard' => 'border-bottom: 1px solid {{VALUE}}',
				],
			]
		);

    $this->end_controls_section();

    }

    protected function render(){
      $settings = $this->get_settings_for_display();
      $element_ID = $this->get_id();
      ?>

      <div class="FAQ-ele-shweb">

        <div id="accordion">

          <?php $boxnum=1;
          foreach ( $settings['list'] as $item ) { ?>

          <div class="faqcard">
            <div class="card-header" id="<?php echo "header-$element_ID-$boxnum" ?>">
              <h5 class="mb-0">
                <button class="btn btn-link<?php
                if ($boxnum=='1') {}else {
                  echo " collapsed";
                }
                ?>" data-toggle="collapse" data-target="<?php echo "#collapse-$element_ID-$boxnum" ?>" aria-expanded="<?php
                if ($boxnum=='1') {
                  echo "true";
                }else {
                  echo "false";
                }
                ?>" aria-controls="<?php echo "#collapse-$element_ID-$boxnum" ?>">
                  <?php echo $item['list_title']; ?>
                </button>
              </h5>
            </div>

            <div id="<?php echo "collapse-$element_ID-$boxnum" ?>" class="collapse<?php
            if ($boxnum=='1') {
              echo " show";
            }
            ?>" aria-labelledby="<?php echo "heading-$element_ID-$boxnum" ?>" data-parent="#accordion">
              <div class="card-body">
                <?php echo $item['list_content']; ?>
              </div>
            </div>
          </div>

        <?php $boxnum = $boxnum+1;
      } ?>

        </div>

      </div>






      <?php } }
