<?php
class HL_Elementor_Widgets {
	protected static $instance = null;
	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}
		return static::$instance;
	}
	protected function __construct() {
		//HL-Elements
		require_once('widgets/posts.php');
		require_once('widgets/courses.php');
		require_once('widgets/customers.php');
		require_once('widgets/form_shortcode.php');
		//HL-Products-Elements
		require_once('products-widgets/PE_title.php');
		require_once('products-widgets/PE_SUB_title.php');
		require_once('products-widgets/PE_breadcrumb.php');
		require_once('products-widgets/PE_course_lessons.php');
		require_once('products-widgets/PE_price.php');
		require_once('products-widgets/PE_addtocart_btn.php');
		require_once('products-widgets/PE_count_sales.php');
		require_once('products-widgets/PE_FAQ.php');
		require_once('products-widgets/PE_single_lesson.php');
		require_once('products-widgets/PE_comments.php');
		require_once('products-widgets/PE_teachers.php');
		// add_action
    add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}
	public function register_widgets() {
		//HL-Elements
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\hm_posts() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\hm_courses() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\hm_customers() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\hm_form_shortcode() );
		//HL-Products-Elements
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\hm_PE_title() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\hm_PE_SUB_title() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\hm_PE_breadcrumb() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\hm_PE_course_lessons() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\hm_PE_price() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\hm_PE_addtocart_btn() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\hm_PE_count_sales() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\hm_PE_FAQ() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\hm_PE_single_lesson() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\hm_PE_comments() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\hm_PE_teachers() );
	}
}
function create_custom_categories( $elements_manager ) {
	$elements_manager->add_category(
		'HL-Elements',
		[
			'title' => 'المان‌های همیار لرن',
			'icon' => 'fa fa-plug',
		]
	);
	$elements_manager->add_category(
		'HL-Products-Elements',
		[
			'title' => 'المان‌های صفحه محصول همیار لرن',
			'icon' => 'fa fa-plug',
		]
	);
}
add_action( 'elementor/elements/categories_registered', 'create_custom_categories' );
////
function HL_Elementors() {
	if (is_plugin_active( 'elementor/elementor.php' )) {
		HL_Elementor_Widgets::get_instance();
	}
}
add_action( 'init', 'HL_Elementors' );
