<?php
/**
 * The Template for displaying all single products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$product = wc_get_product(get_the_id());
?>
	<?php get_header( 'shop' ); ?>

<div class="container">
    <div class="row">
      <div class="backimg indexbackimg probackimg"></div>
    </div>


<div class="row wwsh-cource-area">
	<div class="col-lg-9 col-12 content course-content">
		<div class="theiaStickySidebar">
			<div style="text-align:<?php if (is_rtl()) {echo 'right';}else {echo 'left';} ?>;" class="broadc">
				<?php echo woocommerce_breadcrumb(); ?>
			</div>
			<h1 class="cource-title"><?php the_title(); ?></h1>
			<?php woocommerce_template_single_rating() ?>
			<?php while ( have_posts() ) : the_post(); ?>
				<?php wc_get_template_part( 'content', 'single-product' ); ?>
			<?php endwhile; // end of the loop. ?>
		</div>
	</div>
	<aside class="col-md-3 d-none d-lg-block sidebar">
		<div class="theiaStickySidebar">
			<div class="sidebar-wwsh-box sidebar-wwsh">
				<?php
				/**
				 * woocommerce_sidebar hook.
				 *
				 * @hooked woocommerce_get_sidebar - 10
				*/
				do_action( 'woocommerce_sidebar' ); ?>
			</div>
		</div>
	</aside>
</div>

</div>

<?php if (ot_get_option('enable_mobile_fast_reg' , false) == "on") { ?>
	<div class="mobile-add-to-cart-bottom">
		<a class="atc-btn" href="#course-register">
			<?php echo ot_get_option('mobile_fast_reg_btn_txt' , __('همین الان ثبت‌نام کنید!' , 'hamyarlearn')); ?>
		</a>
	</div>
<?php } ?>


	<?php get_footer( 'shop' );

	/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
