<?php
namespace Elementor;

class hm_posts extends Widget_Base
{
    public function get_name()
    {
        return 'hm_posts';
    }
    public function get_title()
    {
        return __('آخرین مطالب سایت', 'hamyarlearn');
    }
    public function get_icon()
    {
        return 'eicon-posts-grid';
    }
    public function get_categories()
    {
        return [ 'HL-Elements' ];
    }
    protected function _register_controls()
    {
        //start section control (tab:content)
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'hamyarlearn'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'posts_style',
            [
                'label' => __('استایل مطالب', 'hamyarlearn'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'box',
                'options' => [
                    'box'  => __('حالت باکس', 'hamyarlearn'),
                    'magposts' => __('حالت مجله‌ای', 'hamyarlearn'),
                ],
            ]
        );


        $categories = get_categories();
        $cats       = array();
        foreach ($categories as $category) {
            $cats[ $category->term_id ] = $category->name;
        }
        $default = key($cats);
        $this->add_control(
            'categoryid',
            [
                'label'    => __('دسته‌بندی‌ها', 'hamyarlearn'),

                'options'  => $cats,
        'label_block' => true,
        'multiple' => true,
        'default' => $default,
        'type'     => \Elementor\Controls_Manager::SELECT2
            ]
        );

        $this->add_control(
            'posts-number',
            [
                'label' => __('تعداد مطالب', 'hamyarlearn'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'default' => 6,
            ]
        );

        $this->add_control(
            'posts-cols',
            [
                'label' => __('تعداد ستون‌ها', 'hamyarlearn'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 4,
                'step' => 1,
                'default' => 3,
            ]
        );

        $this->add_control(
            'meta_show_intro',
            [
                'label' => __('نمایش یاعدم نمایش متا', 'hamyarlearn'),
                'type' => \Elementor\Controls_Manager::HEADING,
        'condition' => [
            'posts_style' => 'box',
        ],
                'separator' => 'before',
            ]
        );


        $this->add_control(
            'time',
            [
                'label'   => __('تاریخ انتشار', 'hamyarlearn'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
        'condition' => [
            'posts_style' => 'box',
        ],
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'author',
            [
                'label'   => __('نویسنده', 'hamyarlearn'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
        'condition' => [
            'posts_style' => 'box',
        ],
                'default' => 'yes'
            ]
        );


        $this->add_control(
            'post_order',
            [
                'label' => __('مرتب‌سازی براساس', 'hamyarlearn'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'default' => 'DESC',
                'options' => [
                    'ASC' => [
                        'title' => __('صعودی', 'hamyarlearn'),
                        'icon' => 'fa fa-arrow-up'
                    ],
                    'DESC' => [
                        'title' => __('نزولی', 'hamyarlearn'),
                        'icon' => 'fa fa-arrow-down'
                    ],
                ],
                'toggle' => true
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_section',
            [
    'label' => __('ظاهر بخش نمایش مطالب', 'hamyarlearn'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
        );

        $this->add_control(
            'title_intro',
            [
                'label' => __('تنظیمات ظاهر عنوان مطالب', 'hamyarlearn'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'show_title',
            [
                'label' => __('نمایش عنوان مطلب', 'hamyarlearn'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('فعال', 'hamyarlearn'),
                'label_off' => __('غیرفعال', 'hamyarlearn'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('تایپوگرافی عنوان مطلب', 'hamyarlearn'),
                'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .everyart .blog-posts-inner h2, {{WRAPPER}} .postbox-elementor-mode2 card.postbox .blog-posts-inner h3',
        'condition' => [
            'show_title' => 'yes',
        ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'   => __('رنگ عنوان', 'hamyarlearn'),
                'type'    => \Elementor\Controls_Manager::COLOR,
                'default' => '#333',
                'selectors' =>
                [
                    '{{WRAPPER}} .everyart .blog-posts-inner h2, {{WRAPPER}} .postbox-elementor-mode2 card.postbox .blog-posts-inner h3' => 'color: {{VALUE}}'
                ],
        'condition' => [
          'show_title' => 'yes',
        ],
            ]
        );

        $this->add_control(
            'meta_intro',
            [
                'label' => __('تنظیمات ظاهر متای مطالب', 'hamyarlearn'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
        'condition' => [
          'posts_style' => 'box',
        ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'meta_typography',
                'label' => __('تایپوگرافی متن متا', 'hamyarlearn'),
                'scheme' => Scheme_Typography::TYPOGRAPHY_1,
        'condition' => [
            'posts_style' => 'box',
        ],
                'selector' => '{{WRAPPER}} .everyart .blog-posts-inner .post-meta span',
            ]
        );

        $this->add_control(
            'meta_color',
            [
                'label'   => __('رنگ متا', 'hamyarlearn'),
                'type'    => \Elementor\Controls_Manager::COLOR,
                'default' => '#616161',
        'condition' => [
          'posts_style' => 'box',
        ],
                'selectors' =>
                [
                    '{{WRAPPER}} .everyart .blog-posts-inner .post-meta span' => 'color: {{VALUE}}'
                ]
            ]
        );

        $this->add_control(
            'excpert_intro',
            [
                'label' => __('تنظیمات ظاهر متن خلاصه', 'hamyarlearn'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
        'condition' => [
          'posts_style' => 'magposts',
        ],
            ]
        );

        $this->add_control(
            'show_excpert',
            [
                'label' => __('نمایش خلاصه‌ی مطلب', 'hamyarlearn'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('فعال', 'hamyarlearn'),
                'label_off' => __('غیرفعال', 'hamyarlearn'),
                'return_value' => 'yes',
                'default' => 'yes',
        'condition' => [
          'posts_style' => 'magposts',
        ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'excpert_typography',
                'label' => __('تایپوگرافی متن خلاصه', 'hamyarlearn'),
                'scheme' => Scheme_Typography::TYPOGRAPHY_1,
        'condition' => [
          'show_excpert' => 'yes',
          'posts_style' => 'magposts',
        ],
                'selector' => '{{WRAPPER}} .postbox-elementor-mode2 card.postbox .blog-posts-inner .max-height-exc.summery p',
            ]
        );

        $this->add_control(
            'excpert_color',
            [
                'label'   => __('رنگ متن خلاصه', 'hamyarlearn'),
                'type'    => \Elementor\Controls_Manager::COLOR,
                'default' => '#616161',
        'condition' => [
          'show_excpert' => 'yes',
          'posts_style' => 'magposts',
        ],
                'selectors' =>
                [
                    '{{WRAPPER}} .postbox-elementor-mode2 card.postbox .blog-posts-inner .max-height-exc.summery p' => 'color: {{VALUE}}'
                ]
            ]
        );


        $this->add_control(
            'max-width-summery',
            [
                'label' => __('ارتفاع متن خلاصه', 'hamyarlearn'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 80,
                'max' => 1000,
                'step' => 1,
                'default' => 80,
        'selectors' => [
          '{{WRAPPER}} .postbox-elementor-mode2 card.postbox .blog-posts-inner .max-height-exc.summery p' => 'max-height: {{VALUE}}px',
        ],
        'condition' => [
          'show_excpert' => 'yes',
          'posts_style' => 'magposts',
        ],
            ]
        );

        $this->add_control(
            'allbox_intro',
            [
                'label' => __('تنظیمات باکس مطلب', 'hamyarlearn'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'shadowon',
            [
                'label' => __('باکس دارای سایه باشد', 'hamyarlearn'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('باشد', 'hamyarlearn'),
                'label_off' => __('نباشد', 'hamyarlearn'),
                'return_value' => 'yes',
                'default' => 'yes',
        'condition' => [
            'posts_style' => 'box',
        ],
            ]
        );

        $this->add_control(
            'postbox_shadowon_back_color',
            [
                'label'   => __('رنگ پس‌زمینه', 'hamyarlearn'),
                'type'    => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
        'condition' => [
            'shadowon' => 'yes',
        ],
                'selectors' =>
                [
                    '{{WRAPPER}} .everyart a.shadow_postbox' => 'background: {{VALUE}}'
                ]
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $categoryid   = $settings['categoryid'];
        $post_order = $settings['post_order'];
        $postbox1 = new \WP_Query(array(
    'posts_per_page' => $settings['posts-number'],
    'cat'            => $categoryid,
          'order'         =>  $post_order
  ));
        if ($postbox1->have_posts()) :
    ?>
    <div class="row rowkill">
      <?php
      $i=1;
        while ($postbox1->have_posts()):
        $postbox1->the_post();
        $bg_size = $i==5 ? 'full' : 'stthumb';
        if ($settings['posts_style'] == "box") {
            ?>
      <div class="<?php
            if ($settings['posts-cols'] == '1') {
                echo "col-12";
            } elseif ($settings['posts-cols'] == '2') {
                echo "col-lg-6 col-12";
            } elseif ($settings['posts-cols'] == '3') {
                echo "col-lg-4 col-sm-6 col-12";
            } elseif ($settings['posts-cols'] == '4') {
                echo "col-xl-3 col-lg-4 col-sm-6 col-12";
            } else {
                echo "col-lg-4 col-sm-6 col-12";
            } ?>">
      <div class="everyart elementor-postbox">
        <a class="d-block <?php
        if ('yes' === $settings['shadowon']) {
            echo "shadow_postbox";
        } ?>" href="<?php echo the_permalink(get_the_ID()) ?>">
          <figure>
						<?php
                        if ($settings['posts-cols'] == '1') {
                            the_post_thumbnail('');
                        } else {
                            the_post_thumbnail('wwshthumb');
                        } ?>
          </figure>
          <div class="blog-posts-inner">
            <?php if ('yes' === $settings['show_title']) { ?>
              <h2><?php the_title(); ?></h2>
            <?php } ?>
            <div class="post-meta">
              <?php if ($settings['time']): ?>
                <span class="post-date">
                  <i class="fa fa-clock"></i>
                  <?php echo get_the_date('d F Y'); ?>
                </span>
              <?php endif;
            if ($settings['author']):?>
                <span class="post-author">
                  <i class="fa fa-user"></i>
                  <?php the_author() ?>
                </span>
              <?php endif; ?>
            </div>
          </div>
        </a>
      </div>
    </div>
        <?php
        } elseif ($settings['posts_style'] == "magposts") { ?>
          <div class="<?php
                    if ($settings['posts-cols'] == '1') {
                        echo "col-12";
                    } elseif ($settings['posts-cols'] == '2') {
                        echo "col-lg-6 col-12";
                    } elseif ($settings['posts-cols'] == '3') {
                        echo "col-lg-4 col-sm-6 col-12";
                    } elseif ($settings['posts-cols'] == '4') {
                        echo "col-xl-3 col-lg-4 col-sm-6 col-12";
                    } else {
                        echo "col-lg-4 col-sm-6 col-12";
                    } ?> element-posts2">
            <a class="d-block" href="<?php echo the_permalink() ?>">
            <div class="postbox-elementor-mode2">
              <card class="postbox">
                <figure>
									<?php
                                    if ($settings['posts-cols'] == '1') {
                                        the_post_thumbnail('');
                                    } else {
                                        the_post_thumbnail('wwshthumb');
                                    }
                                    ?>
                </figure>
                <div class="blog-posts-inner">
                  <?php if ('yes' === $settings['show_title']) { ?>
                    <h3><?php the_title(); ?></h3>
                  <?php } ?>
                  <?php if ('yes' === $settings['show_excpert']) { ?>
                    <div class="summery max-height-exc">
                      <summery>
                        <?php the_excerpt() ?>
                      </summery>
                    </div>
                  <?php } ?>
                </div>
              </card>
            </div>
            </a>
          </div>
          <?php
        } else {
            echo __("مشکلی وجود دارد!!", 'hamyarlearn');
        } ?>
    <?php $i++;
        endwhile; ?>
    </div>

    <?php wp_reset_postdata(); ?>
  <?php endif; ?>
      <div class="clear"></div>
  <?php
    }
}
