<?php
namespace Elementor;

class hm_PE_price extends Widget_Base
{
    public function get_name()
    {
        return 'hm_PE_price';
    }
    public function get_title()
    {
        return __('نمایش قیمت دوره', 'hamyarlearn');
    }
    public function get_icon()
    {
        return 'eicon-product-price';
    }
    public function get_categories()
    {
        return [ 'HL-Products-Elements' ];
    }
    protected function _register_controls()
    {
        //start section control (tab:content)
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'hamyarlearn'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'note_about_woo_price',
			[
				'label' => __( 'توضیحاتی در مورد این المان', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw' => __( '<div style="font-size:16px; color:#fff; border-radius:10px; padding:10px; line-height:1.9; display:block; background:#F50057; font-weight:500;">این المان، برای قالب همیار لرن می‌باشد.<br>
        با این المان می‌توانید قیمت دوره را نمایش دهید. برای تغییر ظاهر به تب استایل بروید.
        </div>', 'hamyarlearn' ),
				'content_classes' => 'element_title_note',
			]
		);



    		$this->end_controls_section();

        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل عنوان دوره', 'hamyarlearn' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

    $this->add_control(
			'PE_price_text_align',
			[
				'label' => __( 'چیدمان عنوان', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
          'right' => [
						'title' => __( 'راست', 'hamyarlearn' ),
						'icon' => 'fa fa-align-right',
					],
					'center' => [
						'title' => __( 'وسط', 'hamyarlearn' ),
						'icon' => 'fa fa-align-center',
					],
          'left' => [
						'title' => __( 'چپ', 'hamyarlearn' ),
						'icon' => 'fa fa-align-left',
					],
				],
				'default' => 'right',
				'toggle' => true,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'PE_price_typography',
				'label' => __( 'تایپوگرافی قیمت', 'hamyarlearn' ),
				'selector' => '{{WRAPPER}} .ele-cource-price',
			]
		);

    $this->add_control(
			'PE_price_color',
			[
				'label' => __( 'رنگ قیمت', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#f22d33',
				'selectors' => [
					'{{WRAPPER}} .ele-cource-price' => 'color: {{VALUE}}',
				],
			]
		);

    $this->end_controls_section();

    }

    protected function render(){
      $settings = $this->get_settings_for_display(); ?>

      <div style="<?php
      if (!$settings['PE_price_text_align']) {
        $shweb_align = 'right';
      }else {
        $shweb_align = $settings['PE_price_text_align'];
      }
      echo 'text-align:' . $shweb_align ;
      ?>" class="ele-cource-price">
        <?php woocommerce_template_single_price(); ?>
      </div>

  <?php } }
