<?php
namespace Elementor;

class hm_PE_count_sales extends Widget_Base
{
    public function get_name()
    {
        return 'hm_PE_count_sales';
    }
    public function get_title()
    {
        return __('نمایش تعداد فروش دوره', 'hamyarlearn');
    }
    public function get_icon()
    {
        return 'eicon-counter-circle';
    }
    public function get_categories()
    {
        return [ 'HL-Products-Elements' ];
    }
    protected function _register_controls()
    {
        //start section control (tab:content)
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'hamyarlearn'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'note_about_woo_counter',
			[
				'label' => __( 'توضیحاتی در مورد این المان', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw' => __( '<div style="font-size:16px; color:#fff; border-radius:10px; padding:10px; line-height:1.9; display:block; background:#F50057; font-weight:500;">این المان، برای قالب همیار لرن می‌باشد.<br>
        برای تغییر ظاهر به تب استایل بروید. این المان، تعداد فروش/شرکت‌کنندگان دوره را نمایش میدهد.<br>
        ابتدا در تنظیم زیر، نحوه‌ی نمایش را تنظیم کنید:
        </div>', 'hamyarlearn' ),
				'content_classes' => 'element_counter_note',
			]
		);

    $this->add_control(
			'how_count',
			[
				'label' => __( 'نمایش از:', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'woodef',
				'options' => [
					'woodef'  => __( 'نمایش از تعداد فروش دقیق (اتوماتیک)', 'hamyarlearn' ),
					'acfshow' => __( 'نمایش از عدد وارد شده در ویرایش محصول', 'hamyarlearn' ),
					'yours' => __( 'نمایش یک عددی که همین‌جا وارد می‌کنید', 'hamyarlearn' ),
				],
			]
		);

    $this->add_control(
			'your_number',
			[
				'label' => __( 'تعداد شرکت‌کنندگان دوره‌ی شما؟', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 100000000,
				'step' => 1,
				'default' => 50,
        'condition' => [
            'how_count' => 'yours',
        ],
			]
		);



    		$this->end_controls_section();

        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل تعداد شرکت‌کنندگان', 'hamyarlearn' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

    $this->add_control(
			'PE_counter_text_align',
			[
				'label' => __( 'چیدمان متن', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
          'right' => [
						'title' => __( 'راست', 'hamyarlearn' ),
						'icon' => 'fa fa-align-right',
					],
					'center' => [
						'title' => __( 'وسط', 'hamyarlearn' ),
						'icon' => 'fa fa-align-center',
					],
          'left' => [
						'title' => __( 'چپ', 'hamyarlearn' ),
						'icon' => 'fa fa-align-left',
					],
				],
				'default' => 'center',
				'toggle' => true,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'PE_counter_typography',
				'label' => __( 'تایپوگرافی تعداد شرکت‌کنندگان', 'hamyarlearn' ),
				'selector' => '{{WRAPPER}} .ele-cource-counter',
			]
		);

    $this->add_control(
			'PE_counter_color',
			[
				'label' => __( 'رنگ متن تعداد شرکت‌کنندگان', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#31576E',
				'selectors' => [
					'{{WRAPPER}} .ele-cource-counter' => 'color: {{VALUE}}',
				],
			]
		);

    $this->end_controls_section();

    }

    protected function render(){
      $settings = $this->get_settings_for_display(); ?>

      <div style="<?php
      if (!$settings['PE_counter_text_align']) {
        $shweb_align = 'center';
      }else {
        $shweb_align = $settings['PE_counter_text_align'];
      }
      echo 'text-align:' . $shweb_align ;
      ?>" class="ele-cource-counter">
      <?php
      if ($settings['how_count'] == 'woodef') {
        global $product;
        echo $product->get_total_sales();
      }elseif ($settings['how_count'] == 'acfshow') {
        the_field('sidebar-count-webamasters');
      }elseif ($settings['how_count'] == 'yours') {
        echo $settings['your_number'];
      }
      ?>
    </div>

  <?php } }
