<?php
namespace Elementor;

class hm_PE_SUB_title extends Widget_Base
{
    public function get_name()
    {
        return 'hm_PE_SUB_title';
    }
    public function get_title()
    {
        return __('عنوان بخش‌های مختلف', 'hamyarlearn');
    }
    public function get_icon()
    {
        return 'eicon-archive-title';
    }
    public function get_categories()
    {
        return [ 'HL-Products-Elements' ];
    }
    protected function _register_controls()
    {
        //start section control (tab:content)
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'hamyarlearn'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'note_about_woo_title',
			[
				'label' => __( 'توضیحاتی در مورد این المان', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw' => __( '<div style="font-size:16px; color:#fff; border-radius:10px; padding:10px; line-height:1.9; display:block; background:#F50057; font-weight:500;">این المان، برای قالب همیار لرن می‌باشد.<br>
        با این المان می‌توانید عنوان‌هایی با استایل جذاب همیار لرن داشته باشید!
        </div>', 'hamyarlearn' ),
				'content_classes' => 'element_title_note',
			]
		);

    $this->add_control(
			'title_content',
			[
				'label' => __( 'محتوای این عنوان', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'placeholder' => __( 'متن عنوان خود را در اینجا بنویسید.', 'hamyarlearn' ),
			]
		);

    $this->add_control(
			'title_tag',
			[
				'label' => __( 'تگ این عنوان', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'h2',
				'options' => [
					'h1'  => __( 'h1', 'hamyarlearn' ),
					'h2' => __( 'h2', 'hamyarlearn' ),
					'h3' => __( 'h3', 'hamyarlearn' ),
					'h4' => __( 'h4', 'hamyarlearn' ),
					'h5' => __( 'h5', 'hamyarlearn' ),
          'h6' => __( 'h6', 'hamyarlearn' ),
          'span' => __( 'span', 'hamyarlearn' ),
          'div' => __( 'div', 'hamyarlearn' ),
				],
			]
		);

    		$this->end_controls_section();

        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل عنوان دوره', 'hamyarlearn' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'PE_title_typography',
				'label' => __( 'تایپوگرافی متن این عنوان', 'hamyarlearn' ),
				'selector' => '{{WRAPPER}} .all-areas-title',
			]
		);

    $this->add_control(
			'PE_title_color',
			[
				'label' => __( 'رنگ متن این عنوان', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#31576E',
				'selectors' => [
					'{{WRAPPER}} .all-areas-title' => 'color: {{VALUE}}',
				],
			]
		);

    $this->add_control(
			'PE_title_after_color',
			[
				'label' => __( 'رنگ نشانه‌ی متن عنوان دوره', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#FFD000',
				'selectors' => [
					'{{WRAPPER}} .all-areas-title:after' => 'background: {{VALUE}} !important;',
				],
			]
		);

    $this->end_controls_section();

    }

    protected function render(){
      $settings = $this->get_settings_for_display();

      if ($settings['title_tag']=='h1') {
        echo '<h1';
      }elseif ($settings['title_tag']=='h2') {
        echo '<h2';
      }elseif ($settings['title_tag']=='h3') {
        echo '<h3';
      }elseif ($settings['title_tag']=='h4') {
        echo '<h4';
      }elseif ($settings['title_tag']=='h5') {
        echo '<h5';
      }elseif ($settings['title_tag']=='h6') {
        echo '<h6';
      }elseif ($settings['title_tag']=='span') {
        echo '<span';
      }elseif ($settings['title_tag']=='div') {
        echo '<div';
      }else {
        echo '<h2';
      }
      echo ' class="all-areas-title ele-aat-title">' . $settings['title_content'] . '</h2>';

//
} }
